/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinition;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.AbstractWizardPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.common.services.ui.jpa.EntitiesPageComposite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

abstract class EntitiesSelectionPage
extends AbstractWizardPage
implements PropertyChangeListener {
    protected EntitiesPageComposite entitiesComposite;
    protected IServiceDefinition serviceDefinition;
    protected String jpaProjectName = null;

    EntitiesSelectionPage(String pageName, String helpContextID) {
        super(pageName, helpContextID);
        this.setTitle(Messages.EntitiesSelectionPage_title);
    }

    public void createControl(Composite parent) {
        List sdEntityNames = null;
        sdEntityNames = this.serviceDefinition != null ? this.serviceDefinition.getEntityNames() : Collections.emptyList();
        this.entitiesComposite = new EntitiesPageComposite(parent, 0, sdEntityNames, this.jpaProjectName);
        this.entitiesComposite.addPropertyChangeListener((PropertyChangeListener)this);
        this.setControl((Control)this.entitiesComposite);
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)this.entitiesComposite, this.helpContextID);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IStatus status = this.getStatus();
        this.applyToStatusLine(status);
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        IStatus status = this.getStatus();
        if (status == null || status.getSeverity() != 4) {
            this.saveDataToModel();
            return true;
        }
        return false;
    }

    void setJpaProjectName(String projectName) {
        List sdEntityNames = null;
        sdEntityNames = this.serviceDefinition != null ? this.serviceDefinition.getEntityNames() : Collections.emptyList();
        this.entitiesComposite.setJpaProjectName(projectName, sdEntityNames);
    }

    IServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    @Override
    protected IStatus getStatus() {
        List entities = this.entitiesComposite.getSelectedEntities();
        if (entities == null || entities.size() == 0) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.EntitiesSelectionPage_no_entities_error_msg, null);
        }
        return null;
    }

    protected abstract void saveDataToModel();
}

