/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import oracle.eclipse.tools.adf.view.appgen.datamodel.ServiceDefinitionDataModelProvider;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public abstract class DataModelWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.selection = sel;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected static void openEditor(Shell shell, final IFile ... files) {
        assert (files != null);
        if (shell != null && shell.getDisplay() != null) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IFile[] iFileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFile file = iFileArray[n2];
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                            ++n2;
                        }
                    }
                    catch (PartInitException e) {
                        LoggingService.logException((String)"oracle.eclipse.tools.adf.view.ui", (CoreException)((Object)e));
                    }
                }
            });
        }
    }

    protected IFile getSelectionAsFile() {
        Object obj;
        if (this.selection != null && (obj = this.selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)obj;
            IFile file = (IFile)a.getAdapter(IFile.class);
            return file;
        }
        return null;
    }

    protected void openStatusDialog(final Shell shell, final String title, final IStatus status) {
        if (shell != null) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell, (String)title, (String)status.getMessage());
                }
            });
        }
    }

    protected IDataModel createDataModel() {
        try {
            return DataModelFactory.createDataModel((IDataModelProvider)new ServiceDefinitionDataModelProvider());
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            return null;
        }
    }
}

