/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.JavaClassInputComposite;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BindingTypeComposite
extends Composite
implements PropertyChangeListener {
    JavaClassInputComposite classComp;
    private Label seperator;
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private IProject jpaProject = null;
    private static final String BTN_ID_DATACONTROL = "BTN_ID_DATACONTROL";
    private static final String BTN_ID_MANAGEDBEAN = "BTN_ID_MANAGEDBEAN";
    private static final String PROP_ID_CURRENT_DATAOBJECT_ID = "PROP_ID_CURRENT_DATAOBJECT_ID";
    private static final IStatus OK_STATUS = new Status(0, "oracle.eclipse.tools.adf.view.ui", null);

    public BindingTypeComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        Label doLabel = new Label((Composite)this, 0);
        doLabel.setText(Messages.BindingTypeComposite_doLabelStr);
        FormData fd_doLabel = new FormData();
        fd_doLabel.top = new FormAttachment(0, 10);
        fd_doLabel.left = new FormAttachment(0, 10);
        doLabel.setLayoutData((Object)fd_doLabel);
        Button dataControlBtn = new Button((Composite)this, 16);
        dataControlBtn.setText(Messages.BindingTypeComposite_dataControlBtnStr);
        FormData fd_dataControlBtn = new FormData();
        fd_dataControlBtn.top = new FormAttachment((Control)doLabel, 10);
        fd_dataControlBtn.left = new FormAttachment((Control)doLabel, 5, 16384);
        dataControlBtn.setLayoutData((Object)fd_dataControlBtn);
        dataControlBtn.setData((Object)BTN_ID_DATACONTROL);
        dataControlBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                BindingTypeComposite.this.handleDataObjectSelectionChange(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        dataControlBtn.setSelection(true);
        Button managedBeanBtn = new Button((Composite)this, 16);
        managedBeanBtn.setText(Messages.BindingTypeComposite_managedBeanBtnStr);
        FormData fd_managedBeanBtn = new FormData();
        fd_managedBeanBtn.top = new FormAttachment((Control)dataControlBtn, 5);
        fd_managedBeanBtn.left = new FormAttachment((Control)doLabel, 5, 16384);
        managedBeanBtn.setLayoutData((Object)fd_managedBeanBtn);
        managedBeanBtn.setData((Object)BTN_ID_MANAGEDBEAN);
        managedBeanBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                BindingTypeComposite.this.handleDataObjectSelectionChange(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.seperator = new Label((Composite)this, 258);
        FormData fd_seperator = new FormData();
        fd_seperator.top = new FormAttachment((Control)managedBeanBtn, 10);
        fd_seperator.left = new FormAttachment(0, 10);
        fd_seperator.right = new FormAttachment(100, -10);
        this.seperator.setLayoutData((Object)fd_seperator);
        this.seperator.setVisible(false);
        this.classComp = new JavaClassInputComposite(this, 0);
        this.classComp.addPropertyChangeListener(this);
        this.classComp.setProjectLabel(Messages.BindingTypeComposite_projectLabel);
        FormData fd_classComp = new FormData();
        fd_classComp.top = new FormAttachment((Control)this.seperator, 5);
        fd_classComp.left = new FormAttachment(0, 0);
        fd_classComp.right = new FormAttachment(100, 0);
        this.classComp.setLayoutData(fd_classComp);
        this.classComp.setVisible(false);
        this.setTabList(new Control[]{dataControlBtn, managedBeanBtn, this.classComp});
    }

    private void handleDataObjectSelectionChange(SelectionEvent event) {
        Object objData;
        Object source = event.getSource();
        if (source instanceof Button && (objData = ((Button)source).getData()) instanceof String) {
            this.setCurrentDataObjectSelectionID((String)objData);
        }
    }

    private void setCurrentDataObjectSelectionID(String currentID) {
        String oldID = this.getCurrentDataObjectSelectionID();
        if (currentID != null) {
            if (BTN_ID_DATACONTROL.equals(currentID)) {
                this.seperator.setVisible(false);
                this.classComp.setVisible(false);
            } else if (BTN_ID_MANAGEDBEAN.equals(currentID)) {
                this.seperator.setVisible(true);
                this.classComp.setVisible(true);
            }
            this.propertyChange(new PropertyChangeEvent(this, PROP_ID_CURRENT_DATAOBJECT_ID, oldID, currentID));
        }
    }

    private String getCurrentDataObjectSelectionID() {
        String currentID = null;
        if (this.seperator.getVisible() && this.classComp.getVisible()) {
            currentID = BTN_ID_MANAGEDBEAN;
        } else if (!this.seperator.getVisible() && !this.classComp.getVisible()) {
            currentID = BTN_ID_DATACONTROL;
        }
        return currentID;
    }

    void setJpaProjectAndSelection(IProject project, ISelection selection) {
        if (project != this.jpaProject) {
            this.classComp.setProjectInputAndSelection(ProjectUtils.getWebProjects((IProject)project), selection);
            this.layout(true, true);
            this.jpaProject = project;
        }
    }

    IStatus getStatus() {
        IStatus status = null;
        String currentID = this.getCurrentDataObjectSelectionID();
        if (BTN_ID_DATACONTROL.equals(currentID)) {
            status = OK_STATUS;
        } else if (BTN_ID_MANAGEDBEAN.equals(currentID)) {
            List viewerInput = (List)this.classComp.projectViewer.getInput();
            if (viewerInput == null || viewerInput.size() == 0) {
                status = new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.ManagedBeanFromSessionBeanPage_noWebProjectsError, null);
            }
            status = this.classComp.validate("oracle.eclipse.tools.adf.view.ui", Messages.JavaClassInputComposite_selectWebProjectError);
        }
        return status;
    }

    void saveDataToModel(DataWizardModel wizardModel) {
        String currentID = this.getCurrentDataObjectSelectionID();
        if (BTN_ID_DATACONTROL.equals(currentID)) {
            wizardModel.setDataTechnologyType(DataWizardModel.DataTechnologyType.DataControl);
        } else if (BTN_ID_MANAGEDBEAN.equals(currentID)) {
            wizardModel.setDataTechnologyType(DataWizardModel.DataTechnologyType.ManagedBeans);
            this.classComp.saveDataToWizardModel(wizardModel, true);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propChangeSupport.firePropertyChange(evt);
    }
}

