/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWizardPage
extends WizardPage {
    protected String helpContextID;

    protected AbstractWizardPage(String pageName, String helpContextID) {
        super(pageName);
        this.helpContextID = helpContextID;
    }

    public boolean canFlipToNextPage() {
        IStatus status = this.getStatus();
        return status == null || status.getSeverity() != 4;
    }

    public final void performHelp() {
        if (this.helpContextID != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextID);
        }
    }

    protected abstract IStatus getStatus();

    protected void applyToStatusLine(IStatus status) {
        if (status == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return;
        }
        String message = status.getMessage();
        if (message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    protected void updateStatus() {
        IStatus status = this.getStatus();
        this.applyToStatusLine(status);
        this.getWizard().getContainer().updateButtons();
    }
}

