/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.bind;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.WebPageContextManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.properties.DesignerPropertyTool;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.views.properties.PropertyShowInContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BindingSelectionValidator
implements ISelectionListener,
IPartListener {
    private RefreshSourceProvider refreshSourceProvider = new RefreshSourceProvider();
    private boolean validDCBindState = false;
    private boolean validEditComponentState = false;
    private IDOMNode rootNode;

    public BindingSelectionValidator() {
        IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (service != null) {
            service.addSourceProvider((ISourceProvider)this.refreshSourceProvider);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof HTMLEditor) {
            this.validate((HTMLEditor)part, selection);
        } else if (part instanceof IShowInSource) {
            ShowInContext showInContext = ((IShowInSource)part).getShowInContext();
            if (showInContext instanceof PropertyShowInContext) {
                IWorkbenchPart partForPropSheet = ((PropertyShowInContext)showInContext).getPart();
                if (partForPropSheet instanceof HTMLEditor) {
                    IPartService partService = (IPartService)((HTMLEditor)partForPropSheet).getEditorSite().getService(IPartService.class);
                    if (partService != null) {
                        partService.addPartListener((IPartListener)this);
                    }
                } else {
                    this.validate(null, null);
                }
            }
        } else {
            this.validate(null, null);
        }
        if (this.refreshSourceProvider != null) {
            this.refreshSourceProvider.refresh(selection);
        }
    }

    public boolean getValidationDCBindState() {
        return this.validDCBindState;
    }

    public boolean getValidationComponentState() {
        return this.validEditComponentState;
    }

    public IDOMNode getRootNode() {
        return this.rootNode;
    }

    private void validate(HTMLEditor htmlEditor, ISelection selection) {
        Node node;
        IWebPageContext context;
        this.validDCBindState = false;
        this.validEditComponentState = false;
        this.rootNode = null;
        if (htmlEditor != null && selection != null && (context = (IWebPageContext)WebPageContextManager.getInstance().getContext((IWorkbenchPart)htmlEditor)) != null && (node = DesignerPropertyTool.normalizeSelectionToElement((IWorkbenchPart)htmlEditor, (ISelection)selection, (HTMLEditor)htmlEditor)) instanceof IDOMElement) {
            IDOMElement element = (IDOMElement)node;
            this.validDCBindState = !DTRTObjectUtil.getDataControls((IDataControlProvider)context).isEmpty() && context.canBeBound((Element)element);
            this.validEditComponentState = context.canEditBinding((Element)element);
            if (this.validDCBindState || this.validEditComponentState) {
                this.rootNode = (IDOMNode)node;
            }
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof HTMLEditor) {
            IPartService partService = (IPartService)((HTMLEditor)part).getEditorSite().getService(IPartService.class);
            if (partService != null) {
                partService.removePartListener((IPartListener)this);
            }
            this.validate(null, null);
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    class RefreshSourceProvider
    extends AbstractSourceProvider {
        private final String PROP_NAME_SELECTION = "selection";
        private final String[] PROVIDED_SOURCE_NAMES = new String[]{"selection"};
        private final Map<String, Object> STATE_MAP = new HashMap<String, Object>();

        public RefreshSourceProvider() {
            this.STATE_MAP.put("selection", null);
        }

        public void refresh(ISelection selection) {
            this.STATE_MAP.put("selection", selection);
            this.fireSourceChanged(Integer.MAX_VALUE, "selection", selection);
        }

        public void dispose() {
            this.STATE_MAP.put("selection", null);
        }

        public Map getCurrentState() {
            return this.STATE_MAP;
        }

        public String[] getProvidedSourceNames() {
            return this.PROVIDED_SOURCE_NAMES;
        }
    }
}

