/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal;

import oracle.eclipse.tools.adf.view.ADFWebTechnologyExtension;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.internal.Messages;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.ui.internal.IWPEEvent;
import oracle.eclipse.tools.webtier.ui.internal.IWPEOpenCloseListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.utils.EditorUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;

public class WPEOpenCloseListener
implements IWPEOpenCloseListener {
    private boolean _performActivationCheck;

    public void notify(IWPEEvent event) {
        HTMLEditor editor = event.getWPEInstance();
        if (editor == null || event.getEventType() != IWPEEvent.EventType.OPENED && event.getEventType() != IWPEEvent.EventType.ACTIVATED) {
            return;
        }
        if (event.getEventType() == IWPEEvent.EventType.OPENED) {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput != null && this.isFromADFProject(editorInput)) {
                String prop = null;
                prop = EditorUtil.getEditorInputDesignModeProperty((IEditorInput)editorInput);
                if (prop == null) {
                    try {
                        editor.setDesignerMode(3);
                        this._performActivationCheck = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        } else if (event.getEventType() == IWPEEvent.EventType.ACTIVATED && this._performActivationCheck) {
            this._performActivationCheck = false;
            UIJob job = new UIJob(Messages.WPEOpenCloseListener_ShowPalette){
                private final String PalletteViewID = "org.eclipse.gef.ui.palette_view";
                {
                    this.PalletteViewID = "org.eclipse.gef.ui.palette_view";
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IViewPart palette = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.gef.ui.palette_view");
                    if (palette == null) {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.gef.ui.palette_view");
                        }
                        catch (PartInitException e) {
                            Activator.log(e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    private boolean isFromADFProject(IEditorInput editorInput) {
        ADFWebTechnologyExtension techExt;
        Project project;
        IFile file = ((FileEditorInput)editorInput).getFile();
        return file != null && (project = (Project)file.getProject().getAdapter(Project.class)) != null && (techExt = (ADFWebTechnologyExtension)project.getTechnologyExtensionById("adf.web")) != null;
    }
}

