/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal;

import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.impl.DTRTLog;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.BindPosition;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.properties.DesignerPropertyTool;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Node;

public final class DTRTViewUIUtil {
    private static final DTRTLog LOG = new DTRTLog("oracle.eclipse.tools.adf.view.ui");

    private DTRTViewUIUtil() {
    }

    public static void log(String message, Exception throwable) {
        LOG.log(message, (Throwable)throwable);
    }

    public static void log(Throwable throwable) {
        LOG.log(throwable);
    }

    public static void log(IStatus status) {
        LOG.log(status);
    }

    public static HTMLEditor getActiveEditor() {
        try {
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            return editorPart instanceof HTMLEditor ? (HTMLEditor)editorPart : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Node getSelectedNode(HTMLEditor htmlEditor) {
        ISelection selection;
        if (htmlEditor != null && (selection = htmlEditor.getTextEditor().getSelectionProvider().getSelection()) != null && !selection.isEmpty()) {
            return DesignerPropertyTool.normalizeSelectionToElement((IWorkbenchPart)htmlEditor, (ISelection)selection, (HTMLEditor)htmlEditor);
        }
        return null;
    }

    public static IWebPageContext.IBindPosition createBindPosition(IDOMPosition position) {
        if (position != null) {
            Node containerNode = position.getContainerNode();
            if (position.isText()) {
                containerNode = containerNode.getParentNode();
            }
            IDOMPosition refPosition = DOMPositionHelper.toDOMRefPosition((IDOMPosition)position);
            Node container = containerNode;
            Node sibling = refPosition.isText() ? refPosition.getContainerNode().getNextSibling() : refPosition.getNextSiblingNode();
            return new BindPosition(container, sibling);
        }
        return null;
    }

    public static HTMLEditor findOpenEditor(IFile file) {
        if (file != null && PlatformUI.isWorkbenchRunning()) {
            IEditorReference[] editorReferences;
            try {
                editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            }
            catch (Exception exception) {
                editorReferences = null;
            }
            if (editorReferences != null) {
                IEditorReference[] iEditorReferenceArray = editorReferences;
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editorPart = editorReference.getEditor(false);
                    if (editorPart instanceof HTMLEditor && file.equals((Object)DTRTUIUtil.getFile((IWorkbenchPart)editorPart))) {
                        return (HTMLEditor)editorPart;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }
}

