/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal;

import java.io.IOException;
import oracle.eclipse.tools.adf.view.ui.internal.Messages;
import oracle.eclipse.tools.common.ui.util.otn.BrowserLauncher;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryFacetInstallPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ADFWebFacetInstallWizardPage
extends LibraryFacetInstallPage {
    protected static final String ADF_ESSENTIALS_DOWNLOAD_URL = "http://www.oracle.com/technetwork/developer-tools/adf/downloads/adf-download-1649592.html";
    private Label label1 = null;
    private Hyperlink link = null;

    public ADFWebFacetInstallWizardPage() {
        super("oracle.adf.web.install");
        this.setTitle(Messages.ADFFacetInstallWizardPage_title);
        this.setDescription(Messages.ADFFacetInstallWizardPage_description);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateValidation();
        }
    }

    public void setConfig(Object config) {
        super.setConfig(config);
        this.updateDownloadLinks();
    }

    private void updateDownloadLinks() {
        if (this.label1 == null || this.link == null || Display.getCurrent() == null) {
            return;
        }
        IFacetedProjectBase fp = this.getLibraryInstallDelegate().getFacetedProject();
        for (IProjectFacetVersion fv : fp.getProjectFacets()) {
            if (!fv.getProjectFacet().getId().equals("glassfish.web")) continue;
            this.updateLabelAndLinkVisibility(true);
            this.label1.getParent().getParent().pack();
            return;
        }
        this.updateLabelAndLinkVisibility(false);
    }

    private void updateLabelAndLinkVisibility(boolean visible) {
        if (Display.getCurrent() != null) {
            if (this.label1 != null) {
                this.label1.setVisible(visible);
            }
            if (this.link != null) {
                this.link.setVisible(visible);
            }
        }
    }

    protected Control createPageContents(Composite parent) {
        Composite comp = (Composite)super.createPageContents(parent);
        this.label1 = new Label(comp, 64);
        this.label1.setLayoutData((Object)new GridData());
        this.label1.setText(Messages.NeedADFEssentialsClientLib);
        this.link = new Hyperlink(comp, 0);
        this.link.setForeground(JFaceColors.getHyperlinkText((Display)Display.getDefault()));
        this.link.setUnderlined(true);
        this.link.setText(Messages.DownloadADFEssentialsClientLib);
        this.link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                try {
                    BrowserLauncher.displayURL((String)ADFWebFacetInstallWizardPage.ADF_ESSENTIALS_DOWNLOAD_URL);
                }
                catch (IOException iOException) {}
            }
        });
        this.label1.setVisible(false);
        this.link.setVisible(false);
        this.updateDownloadLinks();
        return comp;
    }
}

