/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.wizard;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.IUpdateStructureCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.ui.command.IWizardCommandExecutor;
import oracle.eclipse.tools.adf.dtrt.ui.provider.ISummaryProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.Messages;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

final class DataControlWizardModel {
    private boolean disposeContext;
    private IResource selectedResource;
    private IWizardCommandExecutor<ICreateDataControlCommand> commandExecutor;
    private IDataControlContext context;
    private IDescribable dataControlType;
    private IStructure.IStructureSource structureSource;
    private String dataControlId;
    private boolean canUpdateStructure = false;
    private WizardAction wizardAction = WizardAction.UPDATE;
    private boolean showModifiedFiles = true;
    private boolean showDataControlManagerOnFinish = true;
    private List<ISummaryProvider> summaryProviders;

    public DataControlWizardModel() {
        this.disposeContext = true;
    }

    public DataControlWizardModel(IWizardCommandExecutor<ICreateDataControlCommand> commandExecutor) {
        ICreateDataControlCommand command = (ICreateDataControlCommand)commandExecutor.getCommand();
        this.setContext((IDataControlContext)command.getCommandStack());
        assert (this.getContext() != null);
        this.disposeContext = false;
        this.setStructureSource(command.getStructureSource());
        this.setDataControlType(command.getDataControlType());
        this.commandExecutor = commandExecutor;
    }

    public void dispose() {
        this.selectedResource = null;
        this.dataControlType = null;
        this.structureSource = null;
        this.summaryProviders = null;
        if (this.context != null) {
            if (this.disposeContext) {
                this.context.dispose();
            }
            this.context = null;
        }
    }

    public void setContext(IDataControlContext context) {
        if (this.context != context) {
            this.commandExecutor = null;
            this.summaryProviders = null;
            this.context = context;
        }
    }

    public IDataControlContext getContext() {
        return this.context;
    }

    public IWizardCommandExecutor<ICreateDataControlCommand> getCommandExecutor() {
        if (this.commandExecutor == null && this.getContext() != null) {
            this.commandExecutor = (IWizardCommandExecutor)this.getContext().createCommandExecutor(IWizardCommandExecutor.class, ICreateDataControlCommand.class);
        }
        if (this.commandExecutor != null) {
            ICreateDataControlCommand createDataControlCommand = (ICreateDataControlCommand)this.commandExecutor.getCommand();
            createDataControlCommand.setDataControlType(this.getDataControlType());
            createDataControlCommand.setStructureSource(this.getStructureSource(), this.getDataControlId());
        }
        return this.commandExecutor;
    }

    public void setSelectedResource(IResource selectedResource) {
        this.selectedResource = selectedResource;
    }

    public IResource getSelectedResource() {
        return this.selectedResource;
    }

    public void setDataControlType(IDescribable dataControlType) {
        this.dataControlType = dataControlType;
    }

    public IDescribable getDataControlType() {
        return this.dataControlType;
    }

    public void setStructureSource(IStructure.IStructureSource structureSource) {
        this.structureSource = structureSource;
    }

    public IStructure.IStructureSource getStructureSource() {
        return this.structureSource;
    }

    public void setWizardAction(WizardAction wizardAction) {
        this.wizardAction = wizardAction;
    }

    public WizardAction getWizardAction() {
        return this.isCanUpdateStructure() ? this.wizardAction : WizardAction.CREATE;
    }

    public void setDataControlId(String dataControlId) {
        this.dataControlId = DTRTUtil.isEmpty((String)dataControlId) ? null : dataControlId.trim();
    }

    public String getDataControlId() {
        return this.dataControlId;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
        if (this.getWizardAction() == WizardAction.UPDATE) {
            IUpdateStructureCommand command = (IUpdateStructureCommand)this.getContext().createCommand(IUpdateStructureCommand.class);
            command.setStructureSource(this.getStructureSource());
            this.getContext().setExecuteCommand((ICommand)command);
            this.getContext().execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
        } else if (this.getWizardAction() == WizardAction.CREATE) {
            assert (this.getCommandExecutor() != null);
            this.getCommandExecutor().performFinish(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
        } else {
            throw new IllegalStateException();
        }
        this.getContext().save(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
    }

    public IStatus canPerformFinish() {
        if (this.getContext() != null && this.getWizardAction() != null) {
            IUpdateStructureCommand command;
            IUpdateStructureCommand cmd;
            if (this.getWizardAction() == WizardAction.UPDATE) {
                cmd = (IUpdateStructureCommand)this.getContext().createCommand(IUpdateStructureCommand.class);
                command = cmd.setStructureSource(this.getStructureSource());
            } else if (this.getWizardAction() == WizardAction.CREATE) {
                cmd = (ICreateDataControlCommand)this.getContext().createCommand(ICreateDataControlCommand.class);
                cmd.setDataControlType(this.getDataControlType());
                command = cmd.setStructureSource(this.getStructureSource(), this.getDataControlId());
            } else {
                command = null;
            }
            if (command != null) {
                this.getContext().setExecuteCommand((ICommand)command);
                IStatus status = this.getContext().canExecute();
                if (!status.isOK()) {
                    status = DTRTUtil.getLeafStatus((IStatus)status);
                }
                return status;
            }
        }
        return new Status(4, "oracle.eclipse.tools.adf.view.ui", Messages.cannotPerformFinish);
    }

    public void setShowModifiedFiles(boolean showModifiedFiles) {
        this.showModifiedFiles = showModifiedFiles;
    }

    public boolean isShowModifiedFiles() {
        return this.showModifiedFiles;
    }

    public void setShowDataControlManagerOnFinish(boolean showDataControlManagerOnFinish) {
        this.showDataControlManagerOnFinish = showDataControlManagerOnFinish;
    }

    public boolean isShowDataControlManagerOnFinish() {
        return this.showDataControlManagerOnFinish;
    }

    public void setCanUpdateStructure(boolean canUpdateStructure) {
        this.canUpdateStructure = canUpdateStructure;
    }

    public boolean isCanUpdateStructure() {
        return this.canUpdateStructure;
    }

    public void addSummaryProvider(ISummaryProvider summaryProvider) {
        this.getSummaryProviders().add(summaryProvider);
    }

    public void clearSummaryProviders() {
        if (this.summaryProviders != null) {
            this.summaryProviders.clear();
        }
    }

    List<ISummaryProvider> getSummaryProviders() {
        if (this.summaryProviders == null) {
            this.summaryProviders = new ArrayList<ISummaryProvider>(2);
        }
        return this.summaryProviders;
    }

    public static enum WizardAction {
        UPDATE,
        CREATE;

    }
}

