/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.manager;

import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.BasicObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.context.BasicStructureObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.BaseObjectDetailsPage;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.DetailsPageSectionUtil;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.Messages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IFormPart;

final class StructureObjectDetailsPage
extends BaseObjectDetailsPage {
    public StructureObjectDetailsPage(EditorPage<IDataControlContext> editorPage) {
        super(editorPage);
    }

    void handleStructureSelection(ISelection selection) {
        if (DTRTUIUtil.getFirstElement((ISelection)selection) instanceof IStructureObject) {
            this.getEditorPage().getEditor().setSelection(selection);
        }
    }

    @Override
    public void addDetailPageSection(DetailsPageSectionUtil.IDetailPageSection detailPageSection) {
        super.addDetailPageSection(detailPageSection);
        if (detailPageSection instanceof DetailsPageSectionUtil.StructureListSection) {
            detailPageSection.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructureObjectDetailsPage.this.handleStructureSelection(event.getSelection());
                }
            });
        } else if (detailPageSection instanceof DetailsPageSectionUtil.DataControlListSection) {
            detailPageSection.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructureObjectDetailsPage.this.getEditorPage().getEditor().selectionChanged(event);
                }
            });
        }
    }

    @Override
    public IUIObjectEditor getObjectEditor(IObject object) {
        IUIObjectEditor objectEditor = (IUIObjectEditor)this.getContext().createObjectEditor(IUIObjectEditor.class, object);
        if (objectEditor == null) {
            objectEditor = object instanceof IStructureObject ? new BasicStructureObjectEditor((IStructureObject)object) : new BasicObjectEditor(object);
        }
        objectEditor.addObjectSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                StructureObjectDetailsPage.this.getManagedForm().fireSelectionChanged((IFormPart)StructureObjectDetailsPage.this, selection);
            }
        });
        objectEditor.setClient((IUIObjectEditor.IObjectEditorClient)this.getEditorPage().getEditor());
        return objectEditor;
    }

    @Override
    public String getSectionTitle(IObject object) {
        return object instanceof IStructureObject ? DTRTUtil.getLabel((IDescriptor)((IStructureObject)object).getTypeDescriptor()) : Messages.structureObject;
    }
}

