/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.BaseDetailPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.Outline;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.StructureObjectContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.FormTextHTMLGenerator;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.ui.util.SelectionHelper;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewerComparator;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

final class DetailsPageSectionUtil {
    private DetailsPageSectionUtil() {
    }

    private static abstract class BaseDetailPageSection
    implements IDetailPageSection {
        protected Section section;
        protected PageBook pageBook;
        protected Control pageBookDefaultControl;
        protected Font labelItalicFont;
        protected SelectionHelper selectionHelper;
        private boolean expanded = true;

        private BaseDetailPageSection() {
        }

        public void dispose() {
            if (this.labelItalicFont != null) {
                this.labelItalicFont.dispose();
                this.labelItalicFont = null;
            }
            if (this.selectionHelper != null) {
                this.selectionHelper.dispose();
                this.selectionHelper = null;
            }
            this.section = null;
            this.pageBook = null;
            this.pageBookDefaultControl = null;
        }

        public final void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionHelper != null) {
                this.selectionHelper.addSelectionChangedListener(listener);
            }
        }

        public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionHelper != null) {
                this.selectionHelper.removeSelectionChangedListener((ISelectionChangedListener)this.selectionHelper);
            }
        }

        public final void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }

        public final boolean isExpanded() {
            return this.expanded;
        }

        public final ISelection getSelection() {
            return this.selectionHelper != null ? this.selectionHelper.getSelection() : StructuredSelection.EMPTY;
        }

        public void setSelection(ISelection selection) {
        }

        protected void createControls(IManagedForm managedForm, Composite parent, String sectionTitle, String pageBookDefaultControlText, boolean grabVertical) {
            this.section = BaseDetailPage.createSection((IManagedForm)managedForm, (Composite)parent, (String)sectionTitle, (boolean)grabVertical, (int)(this.isExpanded() ? 64 : 0));
            this.pageBook = new PageBook((Composite)this.section, 0);
            managedForm.getToolkit().adapt((Composite)this.pageBook);
            this.section.setClient((Control)this.pageBook);
            this.pageBookDefaultControl = managedForm.getToolkit().createLabel((Composite)this.pageBook, pageBookDefaultControlText);
            this.labelItalicFont = DTRTUIUtil.createItalicFont((Font)this.pageBookDefaultControl.getFont());
            this.pageBookDefaultControl.setFont(this.labelItalicFont);
            this.pageBook.showPage(this.pageBookDefaultControl);
        }

        @Override
        public final void setInput(IObject object) {
            if (object == null || object.isDisposed() || !this.doSetInput(object)) {
                this.pageBook.showPage(this.pageBookDefaultControl);
            }
        }

        protected abstract boolean doSetInput(IObject var1);

        protected final void bottomAlignment() {
            ((GridData)this.section.getLayoutData()).verticalAlignment = 0x1000008;
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanging(ExpansionEvent e) {
                    GridData gridData = (GridData)BaseDetailPageSection.this.section.getLayoutData();
                    gridData.verticalAlignment = gridData.verticalAlignment == 0x1000008 ? 1 : 0x1000008;
                }
            });
        }

        @Override
        public void refresh(IObject object) {
            if (!this.doSetInput(object)) {
                this.pageBook.showPage(this.pageBookDefaultControl);
            }
            try {
                DTRTUIUtil.controlChanged((Control)this.pageBook);
            }
            catch (Exception exception) {}
        }
    }

    static final class DataControlListSection
    extends FormTextSection<IDataControl> {
        private IDataControlProvider dataControlProvider;

        public DataControlListSection(IDataControlProvider dataControlProvider) {
            this.selectionHelper = new SelectionHelper((ISelectionProvider)this);
            this.dataControlProvider = dataControlProvider;
        }

        @Override
        public void dispose() {
            this.dataControlProvider = null;
            super.dispose();
        }

        @Override
        public void createControls(IManagedForm managedForm, Composite parent, boolean grabVertical) {
            this.createControls(managedForm, parent, Messages.dataControlObjects, Messages.noDataControlForStructure, grabVertical);
            this.createFormText(managedForm, (Composite)this.pageBook);
            ((GridData)this.section.getLayoutData()).verticalAlignment = 0x1000008;
        }

        @Override
        protected void handleLinkActivated(Object object) {
            if (object instanceof IDataControl) {
                StructuredSelection selection = new StructuredSelection(object);
                this.selectionHelper.setSelection((ISelection)selection);
                this.selectionHelper.notifySelectionChangeListeners();
            }
        }

        @Override
        protected boolean doSetInput(IObject object) {
            IStructure structure;
            if (object instanceof IStructureObject && (structure = DTRTObjectUtil.getStructure((IStructureObject)((IStructureObject)object))) != null) {
                ArrayList<IDataControl> dataControls = new ArrayList<IDataControl>();
                try {
                    for (IDataControl dataControl : this.dataControlProvider.getDataControls(null)) {
                        if (!structure.equals((Object)dataControl.getStructureObject())) continue;
                        dataControls.add(dataControl);
                    }
                    Collections.sort(dataControls, DTRTUtil.COMPARATOR);
                    if (this.setInput(dataControls)) {
                        this.pageBook.showPage((Control)this.formText);
                        return true;
                    }
                }
                catch (Exception exception) {}
            }
            return false;
        }
    }

    private static abstract class FormTextSection<T extends IDescribable>
    extends BaseDetailPageSection {
        protected FormText formText;

        private FormTextSection() {
        }

        @Override
        public void dispose() {
            this.formText = null;
            super.dispose();
        }

        protected final void createFormText(IManagedForm managedForm, Composite parent) {
            FormToolkit toolkit = managedForm.getToolkit();
            this.formText = DTRTUIUtil.createFormText((FormToolkit)toolkit, (Composite)parent, (int)(0x48 | toolkit.getOrientation()));
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    Object object = FormTextHTMLGenerator.decodeHRef((FormText)FormTextSection.this.formText, (Object)event.getHref());
                    FormTextSection.this.handleLinkActivated(object);
                }
            });
        }

        protected abstract void handleLinkActivated(Object var1);

        protected final boolean setInput(Collection<? extends T> describables) {
            if (describables != null && !describables.isEmpty()) {
                FormTextHTMLGenerator.HTMLUnorderedList generator = new FormTextHTMLGenerator.HTMLUnorderedList(this.formText);
                for (IDescribable describable : describables) {
                    generator.addLI(this.getLITextPrefix(describable), DTRTUIUtil.getImage((IDescribable)describable), (Object)describable, DTRTUtil.getLabel((IDescribable)describable), DTRTUtil.getToolTipText((IDescribable)describable), null);
                }
                generator.flush();
                DTRTUIUtil.controlChanged((Control)this.formText);
                return true;
            }
            this.formText.setText("", false, false);
            DTRTUIUtil.controlChanged((Control)this.formText);
            return false;
        }

        protected String getLITextPrefix(T describable) {
            return null;
        }
    }

    static interface IDetailPageSection
    extends IDisposable,
    ISelectionProvider {
        public void createControls(IManagedForm var1, Composite var2, boolean var3);

        public void setInput(IObject var1);

        public void refresh(IObject var1);
    }

    static interface IObjectSectionHandler {
        public IUIObjectEditor getObjectEditor(IObject var1);

        public String getSectionTitle(IObject var1);

        public void setObjectEditorControl(IUIObjectEditor var1, Control var2);
    }

    static class ObjectSection
    extends BaseDetailPageSection {
        private IObjectSectionHandler handler;
        private String defaultSectionTitle;
        private IManagedForm managedForm;

        public ObjectSection(IObjectSectionHandler provider) {
            assert (provider != null);
            this.handler = provider;
        }

        @Override
        public void dispose() {
            this.managedForm = null;
            this.handler = null;
            super.dispose();
        }

        @Override
        public void createControls(IManagedForm managedForm, Composite parent, boolean grabVertical) {
            this.managedForm = managedForm;
            this.createControls(managedForm, parent, this.handler.getSectionTitle(null), Messages.noObject, grabVertical);
        }

        @Override
        protected void createControls(IManagedForm managedForm, Composite parent, String sectionTitle, String pageBookDefaultControlText, boolean grabVertical) {
            this.defaultSectionTitle = sectionTitle;
            super.createControls(managedForm, parent, sectionTitle, pageBookDefaultControlText, grabVertical);
        }

        @Override
        protected boolean doSetInput(IObject object) {
            IUIObjectEditor objectEditor;
            if (object != null && (objectEditor = this.handler.getObjectEditor(object)) != null) {
                Control control = objectEditor.createControl(this.managedForm, this.managedForm.getToolkit(), (Composite)this.pageBook);
                objectEditor.refresh();
                this.pageBook.showPage(control);
                DTRTUIUtil.controlChanged((Control)this.pageBook);
                String sectionTitle = this.handler.getSectionTitle(object);
                if (sectionTitle != null) {
                    this.section.setText(sectionTitle);
                }
                this.handler.setObjectEditorControl(objectEditor, control);
                return true;
            }
            this.section.setText(this.defaultSectionTitle);
            return false;
        }

        @Override
        public void refresh(IObject object) {
        }
    }

    static final class OpenableSection
    extends FormTextSection<IOpenable> {
        private IOpenable declarationOpenable;

        OpenableSection() {
        }

        @Override
        public void dispose() {
            this.declarationOpenable = null;
            super.dispose();
        }

        public void setDeclarationOpenable(IOpenable declarationOpenable) {
            this.declarationOpenable = declarationOpenable;
        }

        public IOpenable getDeclarationOpenable() {
            return this.declarationOpenable;
        }

        @Override
        public void createControls(IManagedForm managedForm, Composite parent, boolean grabVertical) {
            this.createControls(managedForm, parent, Messages.openables, Messages.noOpenables, grabVertical);
            this.createFormText(managedForm, (Composite)this.pageBook);
            this.formText.setForeground(DTRTUIUtil.getSectionLabelColor((FormToolkit)managedForm.getToolkit()));
        }

        @Override
        protected void handleLinkActivated(Object object) {
            if (object instanceof IOpenable) {
                DTRTUIUtil.open((IOpenable)((IOpenable)object));
            }
        }

        @Override
        protected boolean doSetInput(IObject object) {
            IOpenable[] openableArray;
            IStructureObject structureObject = object instanceof IDataControlObject ? ((IDataControlObject)object).getStructureObject() : (object instanceof IStructureObject ? (IStructureObject)object : null);
            ArrayList<IOpenable> openables = new ArrayList<IOpenable>();
            if (structureObject != null && (openableArray = (IOpenable[])DTRTUtil.getAdapter((IAdaptable)structureObject, IOpenable[].class)) != null) {
                int i = 0;
                while (i < openableArray.length) {
                    IOpenable openable = openableArray[i];
                    if (openable.canOpen()) {
                        openables.add(openable);
                    }
                    ++i;
                }
            }
            if (this.getDeclarationOpenable() != null && !openables.contains(this.getDeclarationOpenable()) && this.getDeclarationOpenable().canOpen()) {
                openables.add(0, this.getDeclarationOpenable());
            }
            if (this.setInput(openables)) {
                this.pageBook.showPage((Control)this.formText);
                return true;
            }
            return false;
        }

        @Override
        protected String getLITextPrefix(IOpenable describable) {
            return describable.getTypeLabel() != null ? NLS.bind((String)Messages.labelText, (Object)describable.getTypeLabel()) : null;
        }
    }

    static final class StructureListSection
    extends FormTextSection<IStructure> {
        public StructureListSection() {
            this.selectionHelper = new SelectionHelper((ISelectionProvider)this);
        }

        @Override
        public void createControls(IManagedForm managedForm, Composite parent, boolean grabVertical) {
            this.createControls(managedForm, parent, Messages.referencedStructures, Messages.noStructure, grabVertical);
            this.createFormText(managedForm, (Composite)this.pageBook);
        }

        @Override
        protected void handleLinkActivated(Object object) {
            if (object instanceof IStructure) {
                StructuredSelection selection = new StructuredSelection(object);
                this.selectionHelper.setSelection((ISelection)selection);
                this.selectionHelper.notifySelectionChangeListeners();
            }
        }

        @Override
        protected boolean doSetInput(IObject object) {
            if (object instanceof IDataControlObject) {
                object = ((IDataControlObject)object).getStructureObject();
            }
            List structures = null;
            if (object instanceof IStructure) {
                structures = Collections.singletonList((IStructure)object);
            } else if (object instanceof IStructureChild) {
                structures = ((IStructureChild)object).getReferencedStructures();
            }
            if (this.setInput(structures)) {
                this.pageBook.showPage((Control)this.formText);
                return true;
            }
            return false;
        }
    }

    static final class StructureTreeSection
    extends BaseDetailPageSection {
        private FilteredTree filteredTree;

        public StructureTreeSection() {
            this.selectionHelper = new SelectionHelper((ISelectionProvider)this);
        }

        @Override
        public void dispose() {
            this.filteredTree = null;
            super.dispose();
        }

        @Override
        public void createControls(IManagedForm managedForm, Composite parent, boolean grabVertical) {
            this.createControls(managedForm, parent, Messages.structures, Messages.noStructure, grabVertical);
            this.filteredTree = Outline.createFilteredTree((FormToolkit)managedForm.getToolkit(), (Composite)this.pageBook, (PatternFilter)new PatternFilter());
            this.filteredTree.getViewer().setContentProvider((IContentProvider)new StructureObjectContentProvider());
            this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider());
            this.filteredTree.getViewer().setComparator((ViewerComparator)new DescribableViewerComparator());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.filteredTree.getViewer());
            this.filteredTree.getViewer().setAutoExpandLevel(2);
            this.filteredTree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    Object object = DTRTUIUtil.getFirstElement((ISelection)event.getSelection());
                    StructuredSelection selection = object instanceof IStructureObject ? new StructuredSelection(object) : null;
                    StructureTreeSection.this.selectionHelper.setSelection((ISelection)selection);
                    StructureTreeSection.this.selectionHelper.notifySelectionChangeListeners();
                }
            });
            Tree tree = this.filteredTree.getViewer().getTree();
            DTRTUIUtil.applyGrabAllGridData((Control)tree);
            this.bottomAlignment();
        }

        @Override
        public void setSelection(ISelection selection) {
            this.filteredTree.getViewer().setSelection(selection);
        }

        @Override
        protected boolean doSetInput(IObject object) {
            Object[] structures = null;
            if (object instanceof IDataControlObject) {
                object = ((IDataControlObject)object).getStructureObject();
            }
            if (object instanceof IStructure) {
                structures = new Object[]{object};
            } else if (object instanceof IStructureChild) {
                structures = ((IStructureChild)object).getReferencedStructures().toArray();
            }
            if (structures != null && structures.length > 0) {
                this.filteredTree.getViewer().setInput((Object)structures);
                this.pageBook.showPage((Control)this.filteredTree);
                return true;
            }
            this.filteredTree.getViewer().setInput((Object)DTRTUtil.EMPTY_ARRAY);
            return false;
        }
    }
}

