/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.manager;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.editor.CommonEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.DataControlPage;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.Messages;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.StructurePage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public final class DataControlManager
extends CommonEditor<IDataControlContext> {
    public static final String ID = "oracle.eclipse.tools.adf.view.ui.datacontrols.manager.DataControlManager";
    static final String DIALOG_SETTINGS_SECTION_NAME = "DataControlManagerDialogSettings";
    private IProject project;

    public void dispose() {
        this.project = null;
        super.dispose();
    }

    public IProject getProject() {
        IFile file;
        IEditorInput editorInput;
        if (this.project == null && (editorInput = this.getEditorInput()) instanceof FileEditorInput && (file = ((FileEditorInput)editorInput).getFile()) != null) {
            this.project = file.getProject();
        }
        return this.project;
    }

    public String getEditorInputKey() {
        return this.getProject().getFullPath().toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IDataControlContext init() throws CommonEditor.EditorNotInitializedCorrectlyException {
        IProject earProject = DTRTUtil.getEARProject((IResource)this.getProject());
        if (earProject == null) throw new CommonEditor.EditorNotInitializedCorrectlyException(Messages.invalidProjectConfigurationMessage, Messages.invalidProjectConfigurationDescription);
        IDataControlContext context = (IDataControlContext)DTRTUtil.createContext((IResource)this.getProject(), IDataControlContext.class);
        if (context == null) throw new CommonEditor.EditorNotInitializedCorrectlyException(Messages.invalidProjectConfigurationMessage, Messages.invalidProjectConfigurationDescription);
        try {
            if (DTRTUtil.isModelProject((IProject)this.getProject())) {
                context.initialize(this.getProject(), (IProgressMonitor)new NullProgressMonitor());
            } else {
                context.initialize(earProject, this.getProject(), (IProgressMonitor)new NullProgressMonitor());
            }
            assert (context != null);
            this.setPartName(NLS.bind((String)Messages.partName, (Object)this.getProject().getName()));
            context.addListener((IDataControlProvider.IDataControlProviderListener)this);
            return context;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (CoreException e) {
            throw new CommonEditor.EditorNotInitializedCorrectlyException(e.getLocalizedMessage(), e.getStatus().getMessage());
        }
    }

    protected void addEditorPages(List<EditorPage<IDataControlContext>> editorPages) {
        editorPages.add(new DataControlPage(this));
        editorPages.add(new StructurePage(this));
    }

    public String getPageTitle() {
        IProject project = this.getProject();
        return project != null ? NLS.bind((String)Messages.partName, (Object)project.getName()) : null;
    }

    protected String getEditorId() {
        return ID;
    }

    protected String getNavigationLocationName() {
        return Messages.dataControlManager;
    }

    public IObject findObjectByURI(URI objectURI) {
        if (objectURI != null) {
            try {
                IObject object = DTRTObjectUtil.find((Collection)((IDataControlContext)this.getContext()).getDataControls(null), (URI)objectURI);
                if (object == null) {
                    object = DTRTObjectUtil.find((Collection)((IDataControlContext)this.getContext()).getLoadedStructures(), (URI)objectURI);
                }
                return object;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public boolean checkInput() {
        IProject project = this.getProject();
        return project != null && project.isOpen();
    }

    public void handleStructureLoading(IDataControlProvider provider) {
        EditorPage editorPage = this.getEditorPage("Structure Control Objects");
        if (editorPage != null) {
            editorPage.refresh();
        }
    }
}

