/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.manager;

import java.util.Collection;
import java.util.HashSet;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.Outline;
import oracle.eclipse.tools.adf.dtrt.ui.provider.CustomizedStructureObjectLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.LayoutContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.DataControlManager;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.DTRTViewUIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

abstract class BaseOutline
extends Outline<IDataControlContext>
implements LayoutContentProvider.ILayoutChangeListener {
    protected IAction createAction;
    protected IAction deleteAction;
    protected IAction expandAction;
    protected IAction collapseAllAction;

    public BaseOutline(EditorPage<IDataControlContext> editorPage, String identifier) {
        super(editorPage, identifier);
    }

    public void dispose() {
        this.createAction = null;
        this.deleteAction = null;
        this.expandAction = null;
        this.collapseAllAction = null;
        super.dispose();
    }

    protected CustomizedStructureObjectLabelProvider createLabelProvider() {
        CustomizedStructureObjectLabelProvider labelProvider = new CustomizedStructureObjectLabelProvider();
        labelProvider.setValidationMap(this.getEditorPage().getEditor().getValidationMap());
        return labelProvider;
    }

    protected final LayoutContentProvider getContentProvider() {
        return (LayoutContentProvider)super.getContentProvider();
    }

    protected final IContentProvider createContentProvider() {
        LayoutContentProvider contentProvider = this.doCreateContentProvider();
        EditorPage editorPage = this.getEditorPage();
        contentProvider.setMainProject(((DataControlManager)editorPage.getEditor()).getProject());
        IDialogSettings dialogSettings = editorPage.getDialogSettings();
        if (dialogSettings != null) {
            try {
                String key = String.valueOf(editorPage.getEditor().getEditorInputKey()) + '_' + this.getId() + "_layoutIndex";
                if (dialogSettings.get(key) != null) {
                    int index = dialogSettings.getInt(key);
                    contentProvider.setLayout(LayoutContentProvider.Layout.values()[index]);
                }
            }
            catch (Exception e) {
                DTRTViewUIUtil.log(e);
            }
        }
        contentProvider.addLayoutChangeListener((LayoutContentProvider.ILayoutChangeListener)this);
        return contentProvider;
    }

    protected abstract LayoutContentProvider doCreateContentProvider();

    public final void handleLayoutChange(LayoutContentProvider contentProvider, Viewer viewer) {
        EditorPage editorPage;
        IDialogSettings dialogSettings;
        viewer.refresh();
        if (this.getSelection().isEmpty()) {
            this.selectFirstObject();
        }
        if ((dialogSettings = (editorPage = this.getEditorPage()).getDialogSettings()) != null) {
            try {
                String key = String.valueOf(editorPage.getEditor().getEditorInputKey()) + '_' + this.getId() + "_layoutIndex";
                dialogSettings.put(key, contentProvider.getLayout().ordinal());
            }
            catch (Exception e) {
                DTRTViewUIUtil.log(e);
            }
        }
    }

    public final void selectFirstObject() {
        this.expandAction.run();
        super.selectFirstObject();
    }

    protected final void adjustTreeViewer(TreeViewer treeViewer) {
        treeViewer.setAutoExpandLevel(2);
    }

    protected void createActions() {
        this.expandAction = new Action(){

            public void run() {
                try {
                    LayoutContentProvider contentProvider = BaseOutline.this.getContentProvider();
                    HashSet<Object> elements = new HashSet<Object>();
                    for (IObject iObject : BaseOutline.this.getObjects()) {
                        Object parent = contentProvider.getParent((Object)iObject);
                        while (parent != null) {
                            elements.add(parent);
                            parent = contentProvider.getParent(parent);
                        }
                    }
                    BaseOutline.this.getTreeViewer().setExpandedElements(elements.toArray());
                }
                catch (Exception e) {
                    DTRTViewUIUtil.log(e);
                }
            }
        };
        this.expandAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_EXPAND_ALL)));
        this.collapseAllAction = new Action(){

            public void run() {
                BaseOutline.this.getTreeViewer().collapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(Messages.collapseAll);
        this.collapseAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
    }

    protected final IAction getCreateAction() {
        return this.createAction;
    }

    protected final IAction getDeleteAction() {
        return this.deleteAction;
    }

    protected final void doFillToolBar(final Object parent) {
        if (this.collapseAllAction != null) {
            DTRTUIUtil.renderAction((Object)parent, (IAction)this.collapseAllAction);
        }
        if (this.expandAction != null) {
            final int index = this.collapseAllAction == null ? 0 : 1;
            final IContributionItem contributionItem = DTRTUIUtil.renderAction((Object)parent, (IAction)this.expandAction);
            contributionItem.setVisible(true);
            DTRTUIUtil.setVisible((Object)parent, (IContributionItem)contributionItem, (int)index, (this.getContentProvider().getLayout() != LayoutContentProvider.Layout.UNCATEGORIZED ? 1 : 0) != 0);
            this.getContentProvider().addLayoutChangeListener(new LayoutContentProvider.ILayoutChangeListener(){

                public void handleLayoutChange(LayoutContentProvider contentProvider, Viewer viewer) {
                    DTRTUIUtil.setVisible((Object)parent, (IContributionItem)contributionItem, (int)index, (BaseOutline.this.getContentProvider().getLayout() != LayoutContentProvider.Layout.UNCATEGORIZED ? 1 : 0) != 0);
                }
            });
        }
        DTRTUIUtil.renderAction((Object)parent, (IAction)this.getContentProvider().createLayoutAction());
        DTRTUIUtil.renderAction((Object)parent, (IAction)DTRTUIUtil.SEPARATOR_ACTION);
        if (this.createAction != null) {
            DTRTUIUtil.renderAction((Object)parent, (IAction)this.createAction);
        }
        if (this.deleteAction != null) {
            DTRTUIUtil.renderAction((Object)parent, (IAction)this.deleteAction);
        }
        super.doFillToolBar(parent);
    }

    protected abstract Collection<? extends IObject> getObjects();
}

