/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol;

import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.StructureSourceFactory;
import oracle.eclipse.tools.adf.view.ui.datacontrol.Messages;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class DataControlUtil {
    private DataControlUtil() {
    }

    public static IStructure.IStructureSource getSource(Object receiver) {
        if (receiver instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)receiver;
            if (selection.size() == 1) {
                return DataControlUtil.getSource(selection.getFirstElement());
            }
        } else {
            ITypeRoot typeRoot;
            if (receiver instanceof ITypeRoot) {
                return StructureSourceFactory.createTypeSource((ITypeRoot)((ITypeRoot)receiver));
            }
            if (receiver instanceof IAdaptable && (typeRoot = (ITypeRoot)((IAdaptable)receiver).getAdapter(ITypeRoot.class)) != null) {
                return StructureSourceFactory.createTypeSource((ITypeRoot)typeRoot);
            }
        }
        return null;
    }

    public static IDataControlContext createInitializedContext(IStructure.IStructureSource source) throws CoreException {
        IResource resource = DTRTObjectUtil.getResource((IStructure.IStructureSource)source);
        if (resource != null) {
            IProject project = resource.getProject();
            assert (project != null) : resource;
            return DataControlUtil.createInitializedContext(project);
        }
        return null;
    }

    public static IDataControlContext createInitializedContext(IProject project) throws CoreException {
        IDataControlContext context;
        if (project != null && (context = (IDataControlContext)DTRTUtil.createContext((IResource)project, IDataControlContext.class)) != null) {
            try {
                if (DTRTUtil.isWebProject((IProject)project)) {
                    IProject earProject = DTRTUtil.getEARProject((IResource)project);
                    if (earProject != null) {
                        context.initialize(earProject, project, null);
                    }
                } else if (DTRTUtil.isModelProject((IProject)project)) {
                    context.initialize(project, null);
                }
                if (context.isInitialized()) {
                    return context;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    public static ExecutionException toCommandExecutionException(Exception cause) {
        return cause instanceof ExecutionException ? (ExecutionException)cause : new ExecutionException(Messages.errorOnCommand, (Throwable)cause);
    }
}

