/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol;

import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.IUpdateStructureCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.ui.datacontrol.DataControlUtil;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class DataControlPropertyTester
extends PropertyTester {
    private static final String PROP_CAN_CREATE_DATA_CONTROL = "canCreateDataControl";
    private static final String PROP_CAN_UPDATE_STRUCTURE = "canUpdateStructure";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IStructure.IStructureSource source = DataControlUtil.getSource(receiver);
        if (source != null) {
            Class commandType;
            Class clazz = PROP_CAN_CREATE_DATA_CONTROL.equals(property) ? ICreateDataControlCommand.class : (commandType = PROP_CAN_UPDATE_STRUCTURE.equals(property) ? IUpdateStructureCommand.class : null);
            if (commandType != null) {
                IDataControlContext context;
                try {
                    context = DataControlUtil.createInitializedContext(source);
                }
                catch (Exception exception) {
                    context = null;
                }
                if (context != null && context.isInitialized()) {
                    ICommand command = context.createCommand(commandType);
                    context.dispose();
                    if (command != null) {
                        IObjectLocator locator;
                        if (PROP_CAN_UPDATE_STRUCTURE.equals(property) && (locator = ADFPlugin.getObjectLocator()) != null) {
                            IProject project = source.getResource().getProject();
                            boolean hasUpdateableStructure = false;
                            hasUpdateableStructure = DTRTUtil.isModelProject((IProject)project) ? locator.hasUpdateableStructure(source) : locator.hasUpdateableStructure(DTRTUtil.getEARProject((IResource)project), source);
                            return hasUpdateableStructure;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

