/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol;

import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.view.ui.datacontrol.DataControlUtil;
import oracle.eclipse.tools.adf.view.ui.datacontrol.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class DataControlCommandHandler
extends AbstractHandler {
    private static final String VARIABLE_KEY_SELECTION = "selection";

    DataControlCommandHandler() {
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.doExecute(event);
        }
        catch (Exception e) {
            throw DataControlUtil.toCommandExecutionException(e);
        }
        return null;
    }

    private void doExecute(ExecutionEvent event) throws Exception {
        IDataControlContext context;
        Object receiver = HandlerUtil.getVariableChecked((ExecutionEvent)event, (String)VARIABLE_KEY_SELECTION);
        IStructure.IStructureSource source = DataControlUtil.getSource(receiver);
        if (source != null && (context = DataControlUtil.createInitializedContext(source)) != null) {
            try {
                if (this.execute(context, source, null)) {
                    context.save(null);
                }
            }
            finally {
                context.dispose();
            }
            return;
        }
        throw new IllegalStateException(Messages.unknownSelection);
    }

    protected abstract boolean execute(IDataControlContext var1, IStructure.IStructureSource var2, IProgressMonitor var3) throws Exception;
}

