/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.preferences;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractValidationSettingsPage;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ScrolledPageContent;
import org.eclipse.wst.xsl.core.internal.XSLCorePlugin;
import org.eclipse.wst.xsl.ui.internal.Messages;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class XSLValidationPreferencePage
extends AbstractValidationSettingsPage
implements ModifyListener {
    private static final String XSL_UI_PROPERTY_PAGE_PROJECT_VALIDATION_ID = "org.eclipse.wst.xsl.ui.propertyPage.project.validation";
    private static final String XSL_UI_PREFERENCES_VALIDATION_ID = "org.eclipse.wst.xsl.ui.preferences.Validation";
    private static final String[] ERRORS = new String[]{Messages.ErrorLevelText, Messages.WarningLevelText, Messages.IgnoreLevelText};
    private static final int[] ERROR_VALUES;
    private static final Map<Integer, Integer> ERROR_MAP;
    private Text maxErrorsText;
    private Map<String, Combo> combos = new ConcurrentHashMap<String, Combo>();
    private List<ExpandableComposite> Expandables = new CopyOnWriteArrayList<ExpandableComposite>();
    private static final String SETTINGS_SECTION_NAME = "XSLValidationSeverities";
    private PixelConverter fPixelConverter;

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = 1;
        ERROR_VALUES = nArray;
        ERROR_MAP = new ConcurrentHashMap<Integer, Integer>();
        ERROR_MAP.put(2, 0);
        ERROR_MAP.put(1, 1);
        ERROR_MAP.put(0, 2);
    }

    protected Control createCommonContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        page.setLayout((Layout)layout);
        this.fPixelConverter = new PixelConverter((Control)parent);
        Composite content = this.createValidationSection(page);
        this.loadPreferences();
        this.restoreSectionExpansionStates(this.getDialogSettings().getSection(SETTINGS_SECTION_NAME));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        content.setLayoutData((Object)gridData);
        return page;
    }

    protected Composite createValidationSection(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        pageContent.setLayoutData((Object)new GridData(1808));
        pageContent.setExpandHorizontal(true);
        pageContent.setExpandVertical(true);
        Composite body = pageContent.getBody();
        body.setLayout((Layout)layout);
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.horizontalIndent = 0;
        this.createLabel(body, Messages.XSLValidationPreferenceMaxErrorsLabel);
        this.maxErrorsText = this.createTextField(body);
        this.maxErrorsText.addModifyListener((ModifyListener)this);
        Label description = new Label(body, 0);
        description.setText(Messages.XSLValidationPageSeverityLevel);
        description.setFont(pageContent.getFont());
        description.setLayoutData((Object)gd);
        int columns = 3;
        ExpandableComposite twistie = this.createTwistie(body, Messages.XSLValidationPreferenceImportsIncludesLabel, columns);
        Composite inner = this.createInnerComposite(parent, twistie, columns);
        String label = Messages.XSLValidationPreferenceUnresolveImportIncludeLabel;
        this.createCombo(inner, label, "MISSING_INCLUDE");
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, label, "MISSING_INCLUDE");
        this.createCombo(inner, Messages.XSLValidationPreferenceCircularReferencesLabel, "CIRCULAR_REF");
        twistie = this.createTwistie(body, Messages.XSLValidationPreferenceNamedTemplatesLabel, columns);
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Messages.XSLValidationPreferenceTemplateConflictsLabel, "TEMPLATE_CONFLICT");
        this.createCombo(inner, Messages.XSLValidationPreferenceDuplicateParameterLabel, "DUPLICATE_PARAMETER");
        this.createCombo(inner, Messages.XSLValidationPreferenceParamtersWithoutValueLabel, "NAME_ATTRIBUTE_MISSING");
        this.createCombo(inner, Messages.XSLValidationPreferenceMissingParameterAttributeLabel, "NAME_ATTRIBUTE_EMPTY");
        twistie = this.createTwistie(body, Messages.XSLValidationPreferenceCallTemplatesLabel, columns);
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Messages.XSLValidationPreferenceUnresolvedTemplatesLabel, "CHECK_CALL_TEMPLATES");
        this.createCombo(inner, Messages.XSLValidationPreferenceMissingParamtersLabel, "MISSING_PARAM");
        this.createCombo(inner, Messages.XSLValidationPreferenceMissingParameterAttributeLabel, "EMPTY_PARAM");
        twistie = this.createTwistie(body, Messages.XSLValidationPreferenceXPathLabel, columns);
        inner = this.createInnerComposite(parent, twistie, columns);
        this.createCombo(inner, Messages.XSLValidationPreferenceXPathSyntaxLabel, "CHECK_XPATHS");
        return parent;
    }

    private Composite createInnerComposite(Composite parent, ExpandableComposite twistie, int columns) {
        Composite inner = new Composite((Composite)twistie, 0);
        inner.setFont(parent.getFont());
        inner.setLayout((Layout)new GridLayout(columns, false));
        twistie.setClient((Control)inner);
        return inner;
    }

    protected Combo createCombo(Composite parent, String label, String key) {
        Combo combo = this.addComboBox(parent, label, key, ERROR_VALUES, ERRORS, 0);
        this.combos.put(key, combo);
        return combo;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        return text;
    }

    protected ExpandableComposite createTwistie(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                XSLValidationPreferencePage.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.Expandables.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getDialogSettings().addNewSection(SETTINGS_SECTION_NAME));
        super.dispose();
    }

    protected String getQualifier() {
        return XSLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferenceNodeQualifier() {
        return XSLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferencePageID() {
        return XSL_UI_PREFERENCES_VALIDATION_ID;
    }

    protected String getProjectSettingsKey() {
        return "use-project-settings";
    }

    protected IDialogSettings getDialogSettings() {
        return XSLUIPlugin.getDefault().getDialogSettings();
    }

    protected String getPropertyPageID() {
        return XSL_UI_PROPERTY_PAGE_PROJECT_VALIDATION_ID;
    }

    public void init(IWorkbench workbench) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget != null && e.widget.isDisposed()) {
            return;
        }
        this.validateValues();
        this.enableValues();
    }

    protected void storeValues() {
        super.storeValues();
        int maxErrors = Integer.parseInt(this.maxErrorsText.getText());
        Preferences prefs = this.getModelPreferences();
        prefs.putInt("MAX_ERRORS", maxErrors);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            XSLUIPlugin.log((Exception)((Object)ex));
        }
    }

    protected Preferences getModelPreferences() {
        IEclipsePreferences prefs = Platform.getPreferencesService().getRootNode();
        IProject project = this.getProject();
        if (project != null) {
            return prefs.node("project").node(this.getPreferenceNodeQualifier());
        }
        Preferences instanceScope = prefs.node("instance").node(this.getPreferenceNodeQualifier());
        if (instanceScope != null) {
            return instanceScope;
        }
        return prefs.node("default").node(this.getPreferenceNodeQualifier());
    }

    protected boolean loadPreferences() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                XSLValidationPreferencePage.this.initializeValues();
                XSLValidationPreferencePage.this.validateValues();
                XSLValidationPreferencePage.this.enableValues();
            }
        });
        return true;
    }

    protected void initializeValues() {
        Preferences prefs = this.getModelPreferences();
        int maxErrors = prefs.getInt("MAX_ERRORS", 100);
        this.maxErrorsText.setText(String.valueOf(maxErrors));
        for (Map.Entry<String, Combo> entry : this.combos.entrySet()) {
            int val = prefs.getInt(entry.getKey(), 1);
            if (val < 0) {
                val = 1;
            }
            entry.getValue().select(ERROR_MAP.get(val).intValue());
        }
    }

    protected void validateValues() {
        String errorMessage = null;
        try {
            int maxErrors = Integer.parseInt(this.maxErrorsText.getText());
            if (maxErrors < 0) {
                errorMessage = Messages.XSLValidationPreferenceMaxErrorsMsgError;
            }
        }
        catch (NumberFormatException numberFormatException) {
            errorMessage = Messages.XSLValidationPreferenceMaxErrorsMsgError;
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }

    protected void enableValues() {
    }

    protected void performDefaults() {
        this.resetSeverities();
        super.performDefaults();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.storeValues();
        return result;
    }
}

