/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.sqltools.core.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.eclipse.tools.database.sqltools.core.services.OracleSQLSyntax;
import org.eclipse.datatools.sqltools.db.generic.service.GenericSQLService;
import org.eclipse.datatools.sqltools.sql.ISQLSyntax;

public class OracleSQLService
extends GenericSQLService {
    public ISQLSyntax getSQLSyntax() {
        return new OracleSQLSyntax();
    }

    public String[] splitSQL(String sql, boolean splitByDefault) {
        if (!splitByDefault) {
            return new String[]{sql};
        }
        ArrayList<String> groups = new ArrayList<String>();
        this.internalSplitSQL(sql, groups);
        if (groups.size() > 0) {
            return groups.toArray(new String[groups.size()]);
        }
        if (splitByDefault) {
            return this.splitSQLByTerminatorLine(sql, new String[]{";"});
        }
        return new String[]{sql};
    }

    private void internalSplitSQL(String sql, List<String> groups) {
        LinkedList src = LexerToken.parse((String)sql);
        LinkedListTokenIterator srcTokIt = new LinkedListTokenIterator(src);
        LazyNode root = StackParser.parse((LinkedList)src);
        List children = root.shallowChildren();
        int size = children.size();
        if (size == 0) {
            groups.add(sql);
        } else if (size == 1) {
            String sql2 = this.mapTokPosToCharOffset(sql, root, srcTokIt);
            groups.add(this.removeEOSSemiColon(sql2));
        } else {
            boolean allChildrenParen = true;
            int index = 0;
            while (index < size) {
                LazyNode curChild = (LazyNode)children.get(index);
                if (!curChild.startToken.equals("(")) {
                    allChildrenParen = false;
                    break;
                }
                ++index;
            }
            if (allChildrenParen) {
                String sql2 = this.mapTokPosToCharOffset(sql, root, srcTokIt);
                groups.add(this.removeEOSSemiColon(sql2));
                return;
            }
            int groupCharBegin = -1;
            int groupCharEnd = -1;
            index = 0;
            while (index < size) {
                LazyNode curChild = (LazyNode)children.get(index);
                if (curChild.isDDL() && curChild.to - curChild.from <= 3) {
                    if (index < size - 1) {
                        LazyNode nextChild = (LazyNode)children.get(index + 1);
                        if (!nextChild.isCompilationUnit()) continue;
                        LexerToken firstToken = srcTokIt.get(curChild.from);
                        LexerToken lastToken = srcTokIt.get(nextChild.to - 1);
                        groupCharBegin = firstToken.begin;
                        groupCharEnd = lastToken.end;
                        String group = sql.substring(groupCharBegin, groupCharEnd);
                        if (curChild.startToken.equalsIgnoreCase("drop")) {
                            group = this.removeEOSSemiColon(group);
                        }
                        groups.add(group);
                        index += 2;
                        continue;
                    }
                    ++index;
                    continue;
                }
                LexerToken firstToken = srcTokIt.get(curChild.from);
                LexerToken lastToken = srcTokIt.get(curChild.to - 1);
                groupCharBegin = firstToken.begin;
                groupCharEnd = lastToken.end;
                String group = sql.substring(groupCharBegin, groupCharEnd);
                if (!curChild.startToken.equalsIgnoreCase("declare")) {
                    group = this.removeEOSSemiColon(group);
                }
                groups.add(group);
                ++index;
            }
        }
    }

    private String removeEOSSemiColon(String sql) {
        String newSql = sql.trim();
        if (newSql.endsWith(";")) {
            newSql = newSql.substring(0, newSql.length() - 1);
        }
        return newSql;
    }

    private String mapTokPosToCharOffset(String sql, LazyNode node, LinkedListTokenIterator tokenIt) {
        LexerToken firstToken = tokenIt.get(node.from);
        LexerToken lastToken = tokenIt.get(node.to - 1);
        int charBegin = firstToken.begin;
        int charEnd = lastToken.end;
        String group = sql.substring(charBegin, charEnd);
        return group;
    }

    private static class LinkedListTokenIterator {
        private LinkedList<LexerToken> tokens;
        private Iterator<LexerToken> tokenIt;
        private int tokenPos;

        public LinkedListTokenIterator(LinkedList<LexerToken> tokens) {
            this.tokens = tokens;
            this.tokenIt = this.tokens.iterator();
            this.tokenPos = 0;
        }

        /*
         * Unable to fully structure code
         */
        public LexerToken get(int tokenPos) {
            token = null;
            if (this.tokenPos <= tokenPos) ** GOTO lbl6
            throw new IllegalArgumentException();
lbl-1000:
            // 1 sources

            {
                token = this.tokenIt.next();
                ++this.tokenPos;
lbl6:
                // 2 sources

                ** while (this.tokenPos <= tokenPos)
            }
lbl7:
            // 1 sources

            return token;
        }
    }
}

