/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.sqltools.core.services;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.routineeditor.parameter.ParameterInOutWrapper;
import org.eclipse.datatools.sqltools.sqleditor.result.SimpleSQLResultRunnable;
import org.eclipse.debug.core.ILaunchConfiguration;

public class OracleAdHocScriptRunnable
extends SimpleSQLResultRunnable {
    protected ParameterInOutWrapper[] _pws;
    protected String _procName;

    public OracleAdHocScriptRunnable(Connection con, String sql, boolean closeCon, IConnectionTracker tracker, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier, ILaunchConfiguration configuration) {
        super(con, sql, closeCon, tracker, parentMonitor, databaseIdentifier, configuration);
    }

    protected boolean runStatement(Statement stmt) throws SQLException {
        int majorVer = this.getConnection().getMetaData().getDatabaseMajorVersion();
        boolean isWin = System.getProperty("os.name").startsWith("Win");
        if (majorVer < 11 && isWin) {
            this._sql = this._sql.replaceAll("\r\n", "\n");
        }
        return super.runStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSuccess(boolean moreResult) {
        if (this.isTerminated() || this.isCanceled()) {
            return false;
        }
        try {
            this.loopThroughResults(this._stmt, moreResult);
            OperationCommand operationCommand = this.getOperationCommand();
            synchronized (operationCommand) {
                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 3);
            }
        }
        catch (SQLException ex) {
            OperationCommand operationCommand = this.getOperationCommand();
            synchronized (operationCommand) {
                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), ex.getMessage());
                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 6);
            }
            return false;
        }
        return true;
    }
}

