/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import oracle.eclipse.tools.common.upgrade.AbstractProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import oracle.eclipse.tools.common.util.wtp.FacetedProjectMetadata;
import oracle.eclipse.tools.common.util.wtp.ProjectFacetPreferencesMetatdata;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetPreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class JpaProviderFacetsUpgradeParticipant
extends AbstractProjectUpgradeParticipant {
    private static final String JPA_FACET_ID = "jpt.jpa";
    private static final String KODO_FACET_ID = "jpa.kodo";
    private static final String ECLIPSE_FACET_ID = "jpa.eclipselink";
    private static final String PREFS_LIBPROV = "libprov";
    private static final String PREFS_PROVIDER_ID = "provider-id";
    private static final String OWNER_PROJECT_FACETS_ATTR = "owner.project.facets";
    private static HashMap<String, String> USER_LIB_NAME_MAP = new HashMap();

    static {
        USER_LIB_NAME_MAP.put("user-library-provider-eclipselink", "jpa-eclipselink-user-library-provider");
        USER_LIB_NAME_MAP.put("user-library-provider-kodo", "jpa-kodo-user-library-provider");
    }

    public boolean check(IProject project) throws CoreException {
        if (!FacetedProjectMetadata.isFacetedProject((IProject)project)) {
            return false;
        }
        FacetedProjectMetadata md = new FacetedProjectMetadata(project);
        for (FacetedProjectMetadata.InstalledFacet ifacet : md.getInstalledFacets()) {
            if (!KODO_FACET_ID.equals(ifacet.getFacetId()) && !ECLIPSE_FACET_ID.equals(ifacet.getFacetId())) continue;
            return true;
        }
        return false;
    }

    protected void prepare(IProject project, Set<IProjectUpgradeParticipant.Action> actions) {
        IFile f = project.getFile(".settings/org.eclipse.jst.common.project.facet.core.prefs");
        actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
    }

    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        IFacetedProject fproj;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return;
        }
        FacetedProjectMetadata md = new FacetedProjectMetadata(project);
        FacetedProjectMetadata.InstalledFacet jpaProviderFacet = null;
        for (FacetedProjectMetadata.InstalledFacet ifacet : md.getInstalledFacets()) {
            String id = ifacet.getFacetId();
            if (!KODO_FACET_ID.equals(id) && !ECLIPSE_FACET_ID.equals(id)) continue;
            jpaProviderFacet = ifacet;
        }
        if (jpaProviderFacet != null) {
            try {
                ProjectFacetPreferencesMetatdata prefMetadata = new ProjectFacetPreferencesMetatdata(fproj);
                ProjectFacetPreferences providerFacetPrefs = prefMetadata.getPreferences(jpaProviderFacet.getFacetId());
                if (providerFacetPrefs.nodeExists(PREFS_LIBPROV)) {
                    Preferences pref = providerFacetPrefs.node(PREFS_LIBPROV);
                    String providerId = pref.get(PREFS_PROVIDER_ID, null);
                    System.out.println(providerId);
                    prefMetadata.removePreferences(jpaProviderFacet.getFacetId());
                    ProjectFacetPreferences jpaFacetPrefs = prefMetadata.getPreferences(JPA_FACET_ID);
                    pref = jpaFacetPrefs.node(PREFS_LIBPROV);
                    if (USER_LIB_NAME_MAP.containsKey(providerId)) {
                        providerId = USER_LIB_NAME_MAP.get(providerId);
                    }
                    pref.put(PREFS_PROVIDER_ID, providerId);
                    prefMetadata.save();
                    md.removeInstalledFacet(jpaProviderFacet);
                    md.save(project);
                }
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject jproject = JavaCore.create((IProject)project);
                    ArrayList<IClasspathEntry> newClasspathEntryList = new ArrayList<IClasspathEntry>();
                    IClasspathEntry[] iClasspathEntryArray = jproject.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry cpe = iClasspathEntryArray[n2];
                        boolean found = false;
                        IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
                        int n3 = iClasspathAttributeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IClasspathAttribute attr = iClasspathAttributeArray[n4];
                            if (attr.getName().equals(OWNER_PROJECT_FACETS_ATTR) && attr.getValue().equals(jpaProviderFacet.getFacetId())) {
                                found = true;
                            }
                            ++n4;
                        }
                        if (found) {
                            IClasspathEntry newCpe = JpaProviderFacetsUpgradeParticipant.resetOwners(cpe, JPA_FACET_ID);
                            newClasspathEntryList.add(newCpe);
                        } else {
                            newClasspathEntryList.add(cpe);
                        }
                        ++n2;
                    }
                    jproject.setRawClasspath(newClasspathEntryList.toArray(new IClasspathEntry[newClasspathEntryList.size()]), null);
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    private static IClasspathEntry resetOwners(IClasspathEntry cpe, String owners) {
        ArrayList<IClasspathAttribute> attrs = new ArrayList<IClasspathAttribute>();
        IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attr = iClasspathAttributeArray[n2];
            if (!attr.getName().equals(OWNER_PROJECT_FACETS_ATTR)) {
                attrs.add(attr);
            }
            ++n2;
        }
        if (owners != null) {
            attrs.add(JavaCore.newClasspathAttribute((String)OWNER_PROJECT_FACETS_ATTR, (String)owners));
        }
        return new ClasspathEntry(cpe.getContentKind(), cpe.getEntryKind(), cpe.getPath(), cpe.getInclusionPatterns(), cpe.getExclusionPatterns(), cpe.getSourceAttachmentPath(), cpe.getSourceAttachmentRootPath(), cpe.getOutputLocation(), cpe.isExported(), cpe.getAccessRules(), cpe.combineAccessRules(), attrs.toArray(new IClasspathAttribute[attrs.size()]));
    }
}

