/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.kodo.server.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.orm.internal.JptUtil;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProviderFrameworkImpl;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.osgi.framework.Bundle;

public class KodoUtil {
    private static final String PROP_MODULE_NAME = "PROP_MODULE_NAME";
    private static final String PROP_SERVER_ROOT = "serverRootDirectory";
    private static final String PROP_PROJECT_OUTPUT = "projectOutputDirectory";
    private static final String PROP_PROJECT_CLASSPATH = "projectClasspath";
    private static final String PROP_KODO_ENHANCER_BUILDFILE = "/buildfile/build.xml";
    private static final String JAR_PROTOCOL_PREFIX = "jar";

    public static boolean isUsingKodoJPAProvider(IProject project) {
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj == null) {
                return false;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        ILibraryProvider libProvider = LibraryProviderFrameworkImpl.get().getCurrentProvider(project, JptUtil.JPA_FACET);
        if (libProvider == null) {
            return false;
        }
        return "wls-system-library-provider-kodo-4.1".equals(libProvider.getId()) || "wls-system-library-provider-kodo-4.2".equals(libProvider.getId());
    }

    public static void enhanceProject(IRuntime runtime, IProject project, IProgressMonitor monitor) throws JavaModelException {
        block10: {
            IClasspathEntry[] clsPathEntries;
            if (runtime == null || project == null) {
                return;
            }
            IRuntimeType runtimeType = runtime.getRuntimeType();
            if (runtimeType != IWeblogicServerRuntime.RUNTIME_TYPE_10_0) {
                return;
            }
            IJavaProject javaProj = JavaCore.create((IProject)project);
            StringBuilder projClassPathBuilder = new StringBuilder();
            IClasspathEntry[] iClasspathEntryArray = clsPathEntries = javaProj.getRawClasspath();
            int n = clsPathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathContainer container;
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 5 && !(container = JavaCore.getClasspathContainer((IPath)cpe.getPath(), (IJavaProject)javaProj)).getPath().toString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    IClasspathEntry[] iClasspathEntryArray2 = container.getClasspathEntries();
                    int n3 = iClasspathEntryArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry e = iClasspathEntryArray2[n4];
                        File file = e.getPath().toFile();
                        if (file.exists()) {
                            projClassPathBuilder.append(file.getAbsolutePath());
                            projClassPathBuilder.append(File.pathSeparator);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            String wlsHome = runtime.getLocation().toPortableString();
            properties.put(PROP_SERVER_ROOT, wlsHome);
            properties.put(PROP_MODULE_NAME, project.getName());
            IPath outputPath = ResourcesPlugin.getWorkspace().getRoot().getFolder(javaProj.getOutputLocation()).getLocation();
            String projectOutput = outputPath.toPortableString();
            properties.put(PROP_PROJECT_OUTPUT, projectOutput);
            properties.put(PROP_PROJECT_CLASSPATH, projClassPathBuilder.toString());
            try {
                Bundle bundle = Platform.getBundle((String)"oracle.eclipse.tools.database");
                if (bundle == null) {
                    return;
                }
                File buildFile = KodoUtil.computeBuildFile(bundle, PROP_KODO_ENHANCER_BUILDFILE);
                if (buildFile.exists()) {
                    String lanchConfigName = "Oracle Kodo persistence class enhancer ANT task";
                    KodoUtil.runAnt(lanchConfigName, buildFile.getAbsolutePath(), "", properties, monitor);
                    break block10;
                }
                Status s = new Status(4, "oracle.eclipse.tools.database", "Cannot find the build file for Kodo class enhancer ANT task");
                LoggingService.logError((Plugin)OraclePlugin.getInstance(), (String)s.getMessage());
                throw new CoreException((IStatus)s);
            }
            catch (CoreException e) {
                new Status(4, "oracle.eclipse.tools.database", 0, "Rrror running Kodo class enhancer ANT task", (Throwable)e);
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (CoreException)e);
            }
        }
    }

    static void checkReferencedProjects(IRuntime runtime, IProject project, IProgressMonitor monitor) throws CoreException {
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)project);
        IVirtualReference[] refs = earComp.getReferences();
        int i = 0;
        while (i < refs.length) {
            IProject referencedProj;
            IVirtualComponent c = refs[i].getReferencedComponent();
            if (!c.isBinary() && (referencedProj = c.getProject()) != null && !referencedProj.equals((Object)project)) {
                if (KodoUtil.isUsingKodoJPAProvider(referencedProj)) {
                    KodoUtil.enhanceProject(runtime, referencedProj, monitor);
                }
                KodoUtil.checkReferencedProjects(runtime, referencedProj, monitor);
            }
            ++i;
        }
    }

    public static void runAnt(String lanchConfigName, String buildFile, String targets, Map properties, IProgressMonitor monitor) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        if (type == null) {
            Status s = new Status(4, "KODO Plugin", 0, "Ant Launcher Missing", null);
            throw new CoreException((IStatus)s);
        }
        monitor.worked(10);
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, lanchConfigName);
        wc.setContainer(null);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", buildFile);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targets);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
        boolean launchInBackground = true;
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", launchInBackground);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", !launchInBackground);
        wc.setAttribute("org.eclipse.debug.ui.private", true);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.ant.internal.ui.antsupport.InternalAntRunner");
        wc.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
        if (!monitor.isCanceled()) {
            ILaunchConfiguration launchConfig = wc.doSave();
            monitor.worked(10);
            ILaunch launch = launchConfig.launch("run", monitor, false, true);
            monitor.worked(10);
            IProcess[] procs = launch.getProcesses();
            while (!procs[0].isTerminated()) {
                try {
                    monitor.worked(10);
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private static File computeBuildFile(Bundle bundle, String buildFile) throws CoreException {
        URL bundleUrl = bundle.getEntry(buildFile);
        URL fileURL = KodoUtil.resolveURL(bundleUrl);
        if (fileURL.getProtocol().equals(JAR_PROTOCOL_PREFIX)) {
            File tmpFile;
            JarFile jar;
            InputStream is;
            OutputStream os;
            block19: {
                os = null;
                is = null;
                String filename = fileURL.getPath();
                String jarname = fileURL.getFile().substring(0, filename.indexOf(33));
                File jarFile = new File(new URL(jarname).getFile());
                jar = new JarFile(jarFile);
                tmpFile = KodoUtil.createTempFile(buildFile, OraclePlugin.getInstance().getStateLocation().toOSString());
                if (!tmpFile.exists()) break block19;
                File file = tmpFile;
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
                return file;
            }
            os = new FileOutputStream(tmpFile);
            String entryname = buildFile;
            if (entryname.startsWith("/")) {
                entryname = entryname.substring(1);
            }
            JarEntry entry = jar.getJarEntry(entryname);
            is = jar.getInputStream(entry);
            KodoUtil.copy(is, os);
            File file = tmpFile;
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
            return file;
            catch (IOException e) {
                try {
                    Status s = new Status(4, "oracle.eclipse.tools.database", 0, "error creating temporary build file", (Throwable)e);
                    LoggingService.logError((Plugin)OraclePlugin.getInstance(), (String)s.getMessage());
                    throw new CoreException((IStatus)s);
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
        }
        return KodoUtil.resolveFile(fileURL);
    }

    public static URL resolveURL(URL url) {
        try {
            return FileLocator.resolve((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File createTempFile(String name, String dir) {
        if (name == null || dir == null) {
            return null;
        }
        File temp = null;
        String filePath = name.replace('/', File.separatorChar);
        if (filePath.startsWith(File.separator)) {
            filePath = filePath.substring(1);
        }
        temp = new File(dir, filePath);
        KodoUtil.verifyPath(temp, true);
        temp.deleteOnExit();
        return temp;
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        int len = input.read(buf);
        while (len != -1) {
            output.write(buf, 0, len);
            len = input.read(buf);
        }
    }

    private static void verifyPath(File path, boolean isFile) {
        if (isFile && path.getAbsolutePath().endsWith(File.separator)) {
            path = path.getParentFile();
            isFile = false;
        }
        if (path.exists()) {
            return;
        }
        File parent = path.getParentFile();
        KodoUtil.verifyPath(parent, false);
        if (!isFile) {
            path.mkdir();
        }
        path.deleteOnExit();
    }

    public static File resolveFile(URL url) {
        try {
            URL resolvedUrl = KodoUtil.resolveURL(url);
            URI uri = new URI(resolvedUrl.getProtocol(), resolvedUrl.getHost(), resolvedUrl.getPath(), resolvedUrl.getQuery());
            return new File(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

