/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.kodo.server.internal;

import java.util.List;
import oracle.eclipse.tools.database.orm.kodo.server.internal.KodoUtil;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicPublishOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProviderFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class KodoClassEnhancementPublishTaskDelegate
extends PublishTaskDelegate {
    private static final String KODO41_LIB_PROVIDER_ID = "wls-system-library-provider-kodo-4.1";
    public static final IProjectFacet JPA_FACET = ProjectFacetsManager.getProjectFacet((String)"jpt.jpa");
    private static final PublishOperation[] EMPTY_OP_TASK = new PublishOperation[0];
    private WeblogicServer weblogicServer = null;

    public PublishOperation[] getTasks(IServer server, List modules) {
        this.weblogicServer = (WeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
        if (this.weblogicServer == null) {
            return EMPTY_OP_TASK;
        }
        if (modules == null || modules.isEmpty()) {
            return EMPTY_OP_TASK;
        }
        return new PublishOperation[]{new ClassEnhancementPublishOperation(server)};
    }

    private boolean isUsingKodo41(IProject project) {
        boolean ret = false;
        ILibraryProvider libProvider = LibraryProviderFrameworkImpl.get().getCurrentProvider(project, JPA_FACET);
        String providerId = libProvider.getId();
        if (KODO41_LIB_PROVIDER_ID.equals(providerId)) {
            return true;
        }
        return ret;
    }

    private class ClassEnhancementPublishOperation
    extends WeblogicPublishOperation {
        public ClassEnhancementPublishOperation(IServer server) {
            super("PublishKodo", "Run Kodo Class Enhancement", server);
        }

        public int getOrder() {
            return 300;
        }

        protected void processRootModule(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
            if (mod.getKind() == 3) {
                return;
            }
            IModule module = mod.getModule();
            if (module instanceof DeletedModule) {
                return;
            }
            IRuntime runtime = KodoClassEnhancementPublishTaskDelegate.this.weblogicServer.getServer().getRuntime();
            if (FacetUtil.hasWebFacet((IModule)module) || FacetUtil.hasEjbFacet((IModule)module)) {
                IProject proj;
                if (FacetUtil.hasProjectFacet((IModule)module, (IProjectFacet)JPA_FACET) && KodoClassEnhancementPublishTaskDelegate.this.isUsingKodo41(proj = module.getProject())) {
                    KodoUtil.enhanceProject(runtime, proj, monitor);
                }
                KodoUtil.checkReferencedProjects(runtime, module.getProject(), monitor);
            } else if (FacetUtil.hasEarFacet((IModule)module)) {
                IProject project = module.getProject();
                KodoUtil.checkReferencedProjects(runtime, project, monitor);
            }
        }
    }
}

