/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeUtil {
    private static Map mPrimitiveToClassMap = new HashMap(8);
    private static Map mQualifiedMap;

    static {
        mPrimitiveToClassMap.put(Integer.TYPE.getName(), Integer.class.getName());
        mPrimitiveToClassMap.put(Boolean.TYPE.getName(), Boolean.class.getName());
        mPrimitiveToClassMap.put(Character.TYPE.getName(), Character.class.getName());
        mPrimitiveToClassMap.put(Float.TYPE.getName(), Float.class.getName());
        mPrimitiveToClassMap.put(Double.TYPE.getName(), Double.class.getName());
        mPrimitiveToClassMap.put(Byte.TYPE.getName(), Byte.class.getName());
        mPrimitiveToClassMap.put(Short.TYPE.getName(), Short.class.getName());
        mPrimitiveToClassMap.put(Long.TYPE.getName(), Long.class.getName());
        mQualifiedMap = new HashMap(12);
        mQualifiedMap.put("Integer", Integer.class.getName());
        mQualifiedMap.put("Boolean", Boolean.class.getName());
        mQualifiedMap.put("Character", Character.class.getName());
        mQualifiedMap.put("Float", Float.class.getName());
        mQualifiedMap.put("Double", Double.class.getName());
        mQualifiedMap.put("Byte", Byte.class.getName());
        mQualifiedMap.put("Short", Short.class.getName());
        mQualifiedMap.put("Long", Long.class.getName());
        mQualifiedMap.put("Number", Number.class.getName());
        mQualifiedMap.put("String", String.class.getName());
        mQualifiedMap.put("StringBuffer", StringBuffer.class.getName());
        mQualifiedMap.put("Object", Object.class.getName());
    }

    public static boolean isPrimitive(String typeName) {
        return TypeUtil.primitiveToClass(typeName) != null;
    }

    public static boolean isEnumerableClass(Class cl) {
        return Collection.class.isAssignableFrom(cl) || Enumeration.class.isAssignableFrom(cl) || Iterator.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl);
    }

    public static String primitiveToClass(String typeName) {
        return (String)mPrimitiveToClassMap.get(typeName);
    }

    public static String qualify(String className) {
        String qt = (String)TypeUtil.getQualifiedMap().get(className);
        if (qt == null) {
            qt = className;
        }
        return qt;
    }

    public static String unQualifyImplicit(String className) {
        String stdPrefix = "java.lang.";
        if (className.startsWith(stdPrefix)) {
            className = className.substring(stdPrefix.length());
        }
        return className;
    }

    private static Map getQualifiedMap() {
        return mQualifiedMap;
    }

    public static String signatureToJniName(String typeName) {
        int index = typeName.indexOf("[]");
        if (index <= 0) {
            return typeName;
        }
        String componentTypeName = typeName.substring(0, index);
        if (componentTypeName.equals("boolean")) {
            return "[Z";
        }
        if (componentTypeName.equals("byte")) {
            return "[B";
        }
        if (componentTypeName.equals("char")) {
            return "[C";
        }
        if (componentTypeName.equals("double")) {
            return "[D";
        }
        if (componentTypeName.equals("float")) {
            return "[F";
        }
        if (componentTypeName.equals("int")) {
            return "[I";
        }
        if (componentTypeName.equals("long")) {
            return "[J";
        }
        if (componentTypeName.equals("short")) {
            return "[S";
        }
        return "[L" + componentTypeName + ';';
    }

    public static String jniToSignatureName(String typeName) {
        int len = typeName.length();
        if (typeName.charAt(0) != '[') {
            return typeName;
        }
        String componentTypeName = null;
        if (typeName.charAt(len - 1) == ';') {
            if (len > 3 && typeName.charAt(1) == 'L') {
                componentTypeName = typeName.substring(2, len - 1);
            }
        } else if (len == 2) {
            switch (typeName.charAt(1)) {
                case 'Z': {
                    componentTypeName = "boolean";
                    break;
                }
                case 'B': {
                    componentTypeName = "byte";
                    break;
                }
                case 'C': {
                    componentTypeName = "char";
                    break;
                }
                case 'D': {
                    componentTypeName = "double";
                    break;
                }
                case 'F': {
                    componentTypeName = "float";
                    break;
                }
                case 'I': {
                    componentTypeName = "int";
                    break;
                }
                case 'J': {
                    componentTypeName = "long";
                    break;
                }
                case 'S': {
                    componentTypeName = "short";
                }
            }
        }
        if (componentTypeName == null) {
            return typeName;
        }
        return String.valueOf(componentTypeName) + "[]";
    }

    public static String displayName(String typeName) {
        return TypeUtil.unQualifyImplicit(typeName);
    }
}

