/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal.util;

import java.util.Date;

public class ObjectUtil {
    public static String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        return className.substring(0, lastDotIndex);
    }

    public static String getClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int lastDotIndex = fullClassName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return fullClassName;
        }
        return fullClassName.substring(lastDotIndex + 1);
    }

    public static boolean equalObjects(Object o1, Object o2) {
        return ObjectUtil.equalObjects(o1, o2, false);
    }

    public static boolean equalObjects(Object o1, Object o2, boolean ignoreCaseIfStr) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        boolean result = ignoreCaseIfStr && o1 instanceof String && o2 instanceof String ? ((String)o1).equalsIgnoreCase((String)o2) : o1.equals(o2);
        return result;
    }

    public static int compareTo(Object o1, Object o2, boolean ignoreCaseIfStr) {
        if (o1 instanceof String && o2 instanceof String) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return ignoreCaseIfStr ? s1.toLowerCase().compareTo(s2.toLowerCase()) : s1.compareTo(s2);
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o2 instanceof Comparable) {
            return -1 * ((Comparable)o2).compareTo(o1);
        }
        throw new ClassCastException();
    }

    public static boolean isBeforeNow(Date d) {
        if (d == null) {
            return false;
        }
        Date today = new Date();
        return today.after(d);
    }
}

