/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal.util;

public class GrammarUtil {
    public static String pluralise(String name) {
        String lower;
        String result = name;
        if (name.length() == 1) {
            result = String.valueOf(result) + 's';
        } else if (!GrammarUtil.seemsPluralised(name) && !(lower = name.toLowerCase()).endsWith("data")) {
            char secondLast = lower.charAt(name.length() - 2);
            result = !GrammarUtil.isVowel(secondLast) && lower.endsWith("y") ? String.valueOf(name.substring(0, name.length() - 1)) + "ies" : (lower.endsWith("ch") || lower.endsWith("s") ? String.valueOf(name) + "es" : String.valueOf(name) + "s");
        }
        return result;
    }

    public static String singularise(String name) {
        String result = name;
        if (GrammarUtil.seemsPluralised(name)) {
            String lower = name.toLowerCase();
            if (lower.endsWith("ies")) {
                result = String.valueOf(name.substring(0, name.length() - 3)) + "y";
            } else if (lower.endsWith("ches") || lower.endsWith("ses")) {
                result = name.substring(0, name.length() - 2);
            } else if (lower.endsWith("s")) {
                result = name.substring(0, name.length() - 1);
            }
        }
        return result;
    }

    private static final boolean isVowel(char c) {
        boolean vowel = false;
        vowel |= c == 'a';
        vowel |= c == 'e';
        vowel |= c == 'i';
        vowel |= c == 'o';
        vowel |= c == 'u';
        return vowel |= c == 'y';
    }

    private static boolean seemsPluralised(String name) {
        name = name.toLowerCase();
        boolean pluralised = false;
        pluralised |= name.endsWith("es");
        pluralised |= name.endsWith("s");
        return pluralised &= !name.endsWith("ss") && !name.endsWith("us");
    }
}

