/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import oracle.eclipse.tools.database.orm.internal.util.UrlUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class FileUtil {
    private static String CREATE_DIR_ERR = "The directory {0} could not be created.";
    private static String DELETE_FOLDER_ERR = "The directory {0} could not be deleted.";
    private static String DELETE_FILE_ERR = "The file {0} could not be deleted.";
    private static String FILE_READONLY_ERR = "The file {0} could not be modified because write access is denied.\nPlease make sure that the file is not marked as readonly in the file system.";

    public static void copyFiles(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException(FileUtil.get(CREATE_DIR_ERR, dest));
            }
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                FileUtil.copyFiles(new File(src, list[i]), new File(dest, list[i]));
                ++i;
            }
        } else {
            if (dest.exists() && !dest.canWrite()) {
                throw new IOException(FileUtil.get(FILE_READONLY_ERR, dest));
            }
            File destDir = dest.getParentFile();
            if (!destDir.exists() && !destDir.mkdirs()) {
                throw new IOException(FileUtil.get(CREATE_DIR_ERR, dest));
            }
            FileInputStream fin = null;
            OutputStream fout = null;
            BufferedInputStream bfin = null;
            BufferedOutputStream bfout = null;
            boolean failed = false;
            boolean deleteFile = false;
            try {
                try {
                    int c;
                    fin = new FileInputStream(src);
                    bfin = new BufferedInputStream(fin, 8192);
                    fout = new FileOutputStream(dest);
                    deleteFile = true;
                    bfout = new BufferedOutputStream(fout, 8192);
                    while ((c = bfin.read()) >= 0) {
                        bfout.write(c);
                    }
                }
                catch (IOException ex) {
                    failed = true;
                    throw ex;
                }
            }
            finally {
                try {
                    try {
                        if (bfin != null) {
                            bfin.close();
                        }
                        if (fin != null) {
                            fin.close();
                        }
                        if (bfout != null) {
                            bfout.flush();
                            bfout.close();
                        }
                        if (fout != null) {
                            fout.flush();
                            ((FileOutputStream)fout).close();
                        }
                    }
                    catch (IOException ex2) {
                        failed = true;
                        throw ex2;
                    }
                }
                finally {
                    if (failed && deleteFile) {
                        dest.delete();
                    }
                }
                if (failed && deleteFile) {
                    dest.delete();
                }
            }
        }
    }

    public static void deleteFolder(File folder) throws IOException {
        File[] files = folder.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (f.isDirectory()) {
                    FileUtil.deleteFolder(f);
                } else {
                    FileUtil.deletePath(f);
                }
                ++i;
            }
        }
        FileUtil.deletePath(folder);
    }

    public static void deletePath(File f) throws IOException {
        if (!f.delete()) {
            String msgId = f.isDirectory() ? DELETE_FOLDER_ERR : DELETE_FILE_ERR;
            throw new IOException(FileUtil.get(msgId, f.getPath()));
        }
    }

    public static void deleteFiles(File folder) throws IOException {
        File[] files = folder.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (f.isDirectory()) {
                    FileUtil.deleteFiles(f);
                } else {
                    FileUtil.deletePath(f);
                }
                ++i;
            }
        }
    }

    public static String readTextFile(File file) throws IOException {
        return FileUtil.readTextFile(file, System.getProperty("line.separator"));
    }

    public static String readTextFile(Reader reader) throws IOException {
        return FileUtil.readTextFile(reader, System.getProperty("line.separator"));
    }

    public static String readTextFile(InputStream is) throws IOException {
        return FileUtil.readTextFile(is, System.getProperty("line.separator"));
    }

    public static String readTextFile(File file, String lineSep) throws IOException {
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            String string = FileUtil.readTextFile(r, lineSep);
            return string;
        }
    }

    public static String readTextFile(Reader reader, String lineSep) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader br = new BufferedReader(reader);){
            String temp;
            while ((temp = br.readLine()) != null) {
                if (buffer.length() != 0) {
                    buffer.append(lineSep);
                }
                buffer.append(temp);
            }
        }
        return buffer.toString();
    }

    public static String readTextFile(InputStream is, String lineSep) throws IOException {
        try (InputStreamReader r = new InputStreamReader(is, "UTF-8");){
            String string = FileUtil.readTextFile(r, lineSep);
            return string;
        }
    }

    public static void writeTextFile(File file, String data) throws IOException {
        FileUtil.writeFile(file, data.getBytes("UTF-8"));
    }

    public static String readFile(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(reader);
        char[] buffer = new char[32768];
        StringBuffer result = new StringBuffer();
        try {
            int count;
            while ((count = bufferedReader.read(buffer)) != -1) {
                result.append(buffer, 0, count);
            }
        }
        finally {
            buffer = null;
            bufferedReader.close();
            ((Reader)reader).close();
        }
        return result.toString();
    }

    public static byte[] readFile(File src) throws IOException {
        try (FileInputStream fin = new FileInputStream(src);){
            long fileLen = src.length();
            if (fileLen > Integer.MAX_VALUE) {
                throw new IOException("file length too big to be read by FileUtil.readFile: " + fileLen);
            }
            byte[] bytes = new byte[(int)fileLen];
            fin.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public static void writeFile(File dest, byte[] bytes) throws IOException {
        if (dest.exists() && !dest.canWrite()) {
            throw new IOException(FILE_READONLY_ERR);
        }
        FileOutputStream fout = new FileOutputStream(dest.getPath(), false);
        try {
            fout.write(bytes);
        }
        finally {
            fout.flush();
            fout.close();
        }
    }

    public static String removeFileExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return fileName;
        }
        return fileName.substring(0, dotIndex);
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return null;
        }
        return fileName.substring(dotIndex + 1);
    }

    public static URL getFileUrl(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static List getFiles(File directory, String extension, boolean deep) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files == null) {
            return result;
        }
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                if (deep) {
                    result.addAll(FileUtil.getFiles(file, extension, true));
                }
            } else if (extension != null) {
                if (file.getName().toLowerCase().endsWith(extension)) {
                    result.add(file);
                }
            } else {
                result.add(file);
            }
            ++i;
        }
        return result;
    }

    public static List getDeepFiles(File directory, String extension) {
        return FileUtil.getFiles(directory, extension, true);
    }

    public static List getDirectories(File directory, boolean deep) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files == null) {
            return result;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                result.add(file);
                if (deep) {
                    result.addAll(FileUtil.getDirectories(file, true));
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean hasFiles(File directory, String extension) {
        String[] files = directory.list();
        if (files == null) {
            return false;
        }
        if (extension == null) {
            return files.length != 0;
        }
        extension = extension.toLowerCase();
        int i = 0;
        while (i < files.length) {
            if (files[i].toLowerCase().endsWith(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isParentFile(File parent, File child) {
        URL childUrl;
        URL parentUrl;
        try {
            parentUrl = parent.toURL();
            childUrl = child.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return UrlUtil.isParentUrl(parentUrl, childUrl);
    }

    public static int getCountFiles(File folder) {
        if (!folder.exists() || !folder.isDirectory()) {
            return 0;
        }
        File[] files = folder.listFiles();
        int count = files.length;
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                count += FileUtil.getCountFiles(files[i]);
            }
            ++i;
        }
        return count;
    }

    public static String getRelative(File parent, File file) {
        if (!FileUtil.isParentFile(parent, file)) {
            return file.toString();
        }
        try {
            URL parentUrl = parent.toURL();
            URL childUrl = file.toURL();
            return UrlUtil.makeRelative(parentUrl, childUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return file.toString();
        }
    }

    public static String get(String id, Object param) {
        String result = id;
        MessageFormat f = new MessageFormat(result);
        Object[] args = new Object[]{param};
        return f.format(args);
    }

    public static String get(String id, Object param1, Object param2) {
        String result = id;
        MessageFormat f = new MessageFormat(result);
        Object[] args = new Object[]{param1, param2};
        return f.format(args);
    }

    public static void setFileContent(File file, InputStream contents) throws IOException {
        Path path = new Path(file.getAbsolutePath());
        try {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (iFile == null) {
                throw new IOException("The path " + file + " does not seem to be a valid file path.");
            }
            iFile.setContents(contents, true, true, null);
        }
        catch (CoreException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public static void unjar(InputStream in, File dest) throws IOException {
        FileOutputStream out;
        File parent;
        File file;
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if (!dest.isDirectory()) {
            throw new IOException("Destination must be a directory.");
        }
        JarInputStream jin = new JarInputStream(in);
        byte[] buffer = new byte[1024];
        ZipEntry entry = jin.getNextEntry();
        while (entry != null) {
            String fileName = entry.getName();
            if (fileName.charAt(fileName.length() - 1) == '/') {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            if (fileName.charAt(0) == '/') {
                fileName = fileName.substring(1);
            }
            if (File.separatorChar != '/') {
                fileName = fileName.replace('/', File.separatorChar);
            }
            file = new File(dest, fileName);
            if (entry.isDirectory()) {
                file.mkdirs();
                jin.closeEntry();
            } else {
                parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                out = new FileOutputStream(file);
                int len = 0;
                while ((len = jin.read(buffer, 0, buffer.length)) != -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                out.flush();
                ((OutputStream)out).close();
                jin.closeEntry();
                file.setLastModified(entry.getTime());
            }
            entry = jin.getNextEntry();
        }
        Manifest mf = jin.getManifest();
        if (mf != null) {
            file = new File(dest, "META-INF/MANIFEST.MF");
            parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            out = new FileOutputStream(file);
            mf.write(out);
            out.flush();
            ((OutputStream)out).close();
        }
        jin.close();
    }

    public static File extractFilesFromBundle(URL url, Bundle bundle, String path) throws Exception {
        URL jarUrl = UrlUtil.getJarFileUrl(url);
        File jarFile = new File(jarUrl.getFile());
        Location configLocation = Platform.getConfigurationLocation();
        String pluginId = bundle.getSymbolicName();
        File configFolder = new File(configLocation.getURL().getFile(), pluginId);
        File templDir = new File(configFolder, path);
        if (!templDir.exists()) {
            File[] files;
            FileUtil.unjar(new FileInputStream(jarFile), configFolder);
            File[] fileArray = files = configFolder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    f.delete();
                } else if (templDir.getPath().indexOf(f.getPath()) != 0) {
                    FileUtil.deleteFolder(f);
                }
                ++n2;
            }
        }
        return templDir;
    }
}

