/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.orm.internal.JPAConfigurator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.internal.resource.persistence.PersistenceXmlResourceProvider;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnitTransactionType;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.jpa.db.ConnectionProfile;

public class KodoConfigurator
extends JPAConfigurator {
    private static final String ERROR_WRITING_FILE = "Could not write to persistence.xml file.";
    private static final String KODO_JPA_PROVIDER = "kodo.persistence.PersistenceProviderImpl";
    private static final String RESOURCE_LOCAL = "RESOURCE_LOCAL";
    private static final String TRANSACTION_MODE = "kodo.TransactionMode";
    private static final String JDBC_DRIVER = "kodo.ConnectionDriverName";
    private static final String CONNECTION_URL = "kodo.ConnectionURL";
    private static final String JDBC_USER = "kodo.ConnectionUserName";
    private static final String JDBC_PASSWORD = "kodo.ConnectionPassword";
    private static String[] KODO_PROPERTIES = new String[]{"kodo.TransactionMode", "kodo.ConnectionDriverName", "kodo.ConnectionURL", "kodo.ConnectionUserName", "kodo.ConnectionPassword"};
    private static KodoConfigurator instance = new KodoConfigurator();

    private KodoConfigurator() {
    }

    public static KodoConfigurator getInstance() {
        return instance;
    }

    @Override
    public void updatePersistenceXml(IProject project, IProgressMonitor monitor) throws CoreException {
        super.updatePersistenceXml(project, monitor);
        try {
            JpaProject jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
            while (jpaProject == null) {
                Thread.sleep(500L);
                if (monitor.isCanceled()) {
                    return;
                }
                jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
            }
            PersistenceXmlResourceProvider modelProvider = PersistenceXmlResourceProvider.getDefaultXmlResourceProvider((IProject)project);
            JptXmlResource persistenceResource = modelProvider.getXmlResource();
            XmlPersistence persistence = this.getPersistence(persistenceResource);
            XmlPersistenceUnit persistenceUnitResource = this.getPersistenceUnit(project, persistence);
            XmlPersistenceUnitTransactionType newTransactionType = PersistenceFactory.eINSTANCE.createXmlPersistenceUnitTransactionTypeFromString(null, RESOURCE_LOCAL);
            persistenceUnitResource.setTransactionType(newTransactionType);
            persistenceUnitResource.setProvider(KODO_JPA_PROVIDER);
            XmlProperties properties = this.getPersistenceUnitProperties(persistenceUnitResource);
            ConnectionProfile profile = jpaProject.getConnectionProfile();
            if (profile != null) {
                this.setProperty(properties, TRANSACTION_MODE, "local");
                this.setProperty(properties, JDBC_DRIVER, profile.getDriverClassName());
                this.setProperty(properties, CONNECTION_URL, profile.getURL());
                this.setProperty(properties, JDBC_USER, profile.getUserName());
                this.setProperty(properties, JDBC_PASSWORD, profile.getUserPassword());
            }
            persistenceResource.save(null);
        }
        catch (IOException ioe) {
            throw OraclePlugin.createCoreException(ERROR_WRITING_FILE, ioe);
        }
        catch (Exception e) {
            throw OraclePlugin.createCoreException(ERROR_WRITING_FILE, e);
        }
    }

    @Override
    public void cleanupPersistenceXml(IProject project, IProgressMonitor monitor) throws CoreException {
        super.cleanupPersistenceXml(project, monitor);
        try {
            PersistenceXmlResourceProvider modelProvider = PersistenceXmlResourceProvider.getDefaultXmlResourceProvider((IProject)project);
            JptXmlResource persistenceResource = modelProvider.getXmlResource();
            XmlPersistence persistence = this.getPersistence(persistenceResource);
            XmlPersistenceUnit persistenceUnitResource = this.getPersistenceUnit(project, persistence);
            persistenceUnitResource.setTransactionType(null);
            persistenceUnitResource.setProvider("");
            XmlProperties properties = this.getPersistenceUnitProperties(persistenceUnitResource);
            HashSet<String> propNames = new HashSet<String>();
            String[] stringArray = KODO_PROPERTIES;
            int n = KODO_PROPERTIES.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                propNames.add(s);
                ++n2;
            }
            Iterator it = properties.getProperties().iterator();
            while (it.hasNext()) {
                XmlProperty property = (XmlProperty)it.next();
                if (!propNames.contains(property.getName())) continue;
                it.remove();
            }
            persistenceResource.save(null);
        }
        catch (IOException ioe) {
            throw OraclePlugin.createCoreException(ERROR_WRITING_FILE, ioe);
        }
        catch (Exception e) {
            throw OraclePlugin.createCoreException(ERROR_WRITING_FILE, e);
        }
    }
}

