/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal;

import oracle.eclipse.tools.database.orm.eclipselink.EclipseLinkCoreMessages;
import oracle.eclipse.tools.database.orm.internal.EclipseLinkConfigurator;
import oracle.eclipse.tools.database.orm.internal.JptUtil;
import oracle.eclipse.tools.database.orm.internal.KodoConfigurator;
import oracle.eclipse.tools.database.orm.kodo.server.internal.KodoUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProviderFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class JpaFacetedInstallChangeListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent event) {
        final IProjectFacetActionEvent actionEvent = (IProjectFacetActionEvent)event;
        IProjectFacet projectFacet = actionEvent.getProjectFacet();
        if (projectFacet.getId().equals("jpt.jpa")) {
            if (actionEvent.getType() == IFacetedProjectEvent.Type.POST_INSTALL) {
                WorkspaceJob job = new WorkspaceJob(EclipseLinkCoreMessages.updatingPersistenceXMl){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        JpaFacetedInstallChangeListener.this.updatePersistenceXml(actionEvent.getProject().getProject(), monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule(1000L);
            } else if (actionEvent.getType() == IFacetedProjectEvent.Type.PRE_UNINSTALL) {
                WorkspaceJob job = new WorkspaceJob(EclipseLinkCoreMessages.updatingPersistenceXMl){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        JpaFacetedInstallChangeListener.this.cleanupPersistenceXml(actionEvent.getProject().getProject(), monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    private void updatePersistenceXml(IProject project, IProgressMonitor monitor) throws CoreException {
        ILibraryProvider libProvider = LibraryProviderFrameworkImpl.get().getCurrentProvider(project, JptUtil.JPA_FACET);
        if (libProvider == null) {
            return;
        }
        ILibraryProvider rootProvider = libProvider.getRootProvider();
        String providerId = libProvider.getId();
        if (providerId.startsWith("wls-system-library-provider-eclipselink")) {
            EclipseLinkConfigurator.getInstance().updatePersistenceXml(project, monitor);
            return;
        }
        if (KodoUtil.isUsingKodoJPAProvider(project)) {
            KodoConfigurator.getInstance().updatePersistenceXml(project, monitor);
            return;
        }
        if ("user-library-provider".equals(rootProvider.getId()) && this.isUsingEclipseLinkLib(project)) {
            EclipseLinkConfigurator.getInstance().updatePersistenceXml(project, monitor);
        }
    }

    private void cleanupPersistenceXml(IProject project, IProgressMonitor monitor) throws CoreException {
        ILibraryProvider libProvider = LibraryProviderFrameworkImpl.get().getCurrentProvider(project, JptUtil.JPA_FACET);
        if (libProvider == null) {
            return;
        }
        ILibraryProvider rootProvider = libProvider.getRootProvider();
        if ("wls-system-library-provider-eclipselink".equals(libProvider.getId())) {
            EclipseLinkConfigurator.getInstance().cleanupPersistenceXml(project, monitor);
        } else {
            if (KodoUtil.isUsingKodoJPAProvider(project)) {
                KodoConfigurator.getInstance().cleanupPersistenceXml(project, monitor);
                return;
            }
            if ("user-library-provider".equals(rootProvider.getId()) && this.isUsingEclipseLinkLib(project)) {
                EclipseLinkConfigurator.getInstance().cleanupPersistenceXml(project, monitor);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isUsingEclipseLinkLib(IProject project) {
        IJavaProject javaProj = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] classpathEntries;
            IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProj.getResolvedClasspath(true);
            int n = classpathEntries.length;
            int n2 = 0;
            while (true) {
                IPath path;
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 1 && (path = cpe.getPath()).toString().indexOf("eclipselink.jar") >= 0) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

