/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal;

import java.io.File;
import oracle.eclipse.tools.database.OraclePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.internal.resource.persistence.PersistenceXmlResourceProvider;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;

public abstract class JPAConfigurator {
    protected XmlPersistence getPersistence(JptXmlResource persistenceResource) {
        if (persistenceResource.getRootObject() != null) {
            return (XmlPersistence)persistenceResource.getRootObject();
        }
        XmlPersistence ret = PersistenceFactory.eINSTANCE.createXmlPersistence();
        persistenceResource.getContents().add((Object)ret);
        return ret;
    }

    protected XmlProperties getPersistenceUnitProperties(XmlPersistenceUnit persistenceUnitResource) {
        if (persistenceUnitResource.getProperties() != null) {
            return persistenceUnitResource.getProperties();
        }
        XmlProperties properties = PersistenceFactory.eINSTANCE.createXmlProperties();
        persistenceUnitResource.setProperties(properties);
        return properties;
    }

    protected XmlPersistenceUnit getPersistenceUnit(IProject project, XmlPersistence persistence) {
        XmlPersistenceUnit persistenceUnitResource = null;
        if (persistence.getPersistenceUnits() != null && persistence.getPersistenceUnits().size() > 0) {
            persistenceUnitResource = (XmlPersistenceUnit)persistence.getPersistenceUnits().get(0);
        } else {
            persistenceUnitResource = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
            persistenceUnitResource.setName(project.getName());
            persistence.getPersistenceUnits().add((Object)persistenceUnitResource);
        }
        return persistenceUnitResource;
    }

    protected void setProperty(XmlProperties properties, String name, String value) {
        XmlProperty property = PersistenceFactory.eINSTANCE.createXmlProperty();
        property.setName(name);
        property.setValue(value);
        properties.getProperties().add((Object)property);
    }

    public void updatePersistenceXml(final IProject project, IProgressMonitor monitor) throws CoreException {
        WorkspaceJob updateJob = new WorkspaceJob("Updating persistence.xml"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                JptXmlResource persistenceResource = JPAConfigurator.this.getPersistenceResource(project, monitor);
                if (persistenceResource == null) {
                    return OraclePlugin.createErrorStatus("persistence.xml not updated");
                }
                IFile file = persistenceResource.getFile();
                if (!file.exists()) {
                    throw OraclePlugin.createCoreException("persistence.xml not found in project " + project.getName());
                }
                File f = file.getLocation().toFile();
                if (!f.canWrite()) {
                    String msg = "Failed to update " + f.getName() + ". The file is readonly. Please make sure the file is writable and reinstall the facet.";
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.database", msg));
                }
                XmlPersistence persistence = JPAConfigurator.this.getPersistence(persistenceResource);
                if (persistence.getVersion() == null) {
                    persistence.setVersion("1.0");
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.schedule(200L);
    }

    private JptXmlResource getPersistenceResource(IProject project, IProgressMonitor monitor) throws CoreException {
        JptXmlResource persistenceResource = null;
        int retry = 20;
        while (retry > 0) {
            PersistenceXmlResourceProvider modelProvider = PersistenceXmlResourceProvider.getXmlResourceProvider((IProject)project, (IPath)XmlPersistence.DEFAULT_RUNTIME_PATH);
            try {
                --retry;
                persistenceResource = modelProvider.getXmlResource();
                if (persistenceResource != null) break;
                if (!monitor.isCanceled()) continue;
                return null;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                    if (!monitor.isCanceled()) continue;
                    return null;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (persistenceResource == null) {
            throw OraclePlugin.createCoreException("persistence.xml not found in project " + project.getName());
        }
        return persistenceResource;
    }

    public void cleanupPersistenceXml(IProject project, IProgressMonitor monitor) throws CoreException {
        JptXmlResource persistenceResource = this.getPersistenceResource(project, monitor);
        if (persistenceResource == null) {
            return;
        }
        IFile file = persistenceResource.getFile();
        if (!file.exists()) {
            throw OraclePlugin.createCoreException("persistence.xml not found in project " + project.getName());
        }
        File f = file.getLocation().toFile();
        if (!f.canWrite()) {
            String msg = "Failed to update " + f.getName() + ". The file is readonly. Please make sure the file is writable and reinstall the facet.";
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.database", msg));
        }
    }
}

