/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.eclipselink.server.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.database.orm.eclipselink.EclipseLinkCoreMessages;
import oracle.eclipse.tools.database.orm.internal.JptUtil;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicPublishOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProviderFrameworkImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class EclipseLinkJarPublishTask
extends PublishTaskDelegate {
    private static final PublishOperation[] EMPTY_OP_TASK = new PublishOperation[0];
    private IServer server = null;
    private WeblogicServer weblogicServer = null;

    public PublishOperation[] getTasks(IServer server, List modules) {
        this.weblogicServer = (WeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
        this.server = server;
        if (this.weblogicServer == null) {
            return EMPTY_OP_TASK;
        }
        if (this.weblogicServer.isRemote()) {
            return EMPTY_OP_TASK;
        }
        if (modules == null || modules.isEmpty()) {
            return EMPTY_OP_TASK;
        }
        return new PublishOperation[]{new PublishEclipseLinkJarToWlsDomainOperation(server)};
    }

    private void checkReferencedProjects(IProject project, boolean isEarModule, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetProject = ProjectFacetsManager.create((IProject)project);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)project);
        IVirtualReference[] refs = earComp.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualComponent c = refs[i].getReferencedComponent();
            IProject p = c.getProject();
            if (p != null) {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)p);
                if (facetProject != null && facetedProject.hasProjectFacet(JptUtil.JPA_FACET)) {
                    if (this.isUsingEclipseLinkUserLib(p)) {
                        this.copyEclipseLinkJarToDomain(p, monitor);
                    }
                    return;
                }
                if (isEarModule) {
                    this.checkReferencedProjects(p, false, monitor);
                }
            }
            ++i;
        }
    }

    public void copyEclipseLinkJarToDomain(IProject project, IProgressMonitor monitor) {
        if (this.weblogicServer == null) {
            return;
        }
        IPath domainPath = this.weblogicServer.getDomainPath();
        IPath libPath = domainPath.append("lib");
        File libDir = libPath.toFile();
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        boolean needRestartWls = false;
        IJavaProject javaProj = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] classpathEntries;
            IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProj.getResolvedClasspath(true);
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path;
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 1 && (path = cpe.getPath()).toString().indexOf("eclipselink.jar") >= 0) {
                    File f = cpe.getPath().toFile();
                    File target = new File(libDir, f.getName());
                    try {
                        if (!target.exists()) {
                            FileUtil.copy((File)f, (File)target);
                            if (this.warnEclipseJarReloadIssue()) {
                                needRestartWls = true;
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            if (needRestartWls) {
                monitor.setCanceled(true);
                this.server.restart("run", (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean warnEclipseJarReloadIssue() {
        final String message = String.valueOf(EclipseLinkCoreMessages.warnEclipseRedeployIssueOnWls1) + EclipseLinkCoreMessages.warnEclipseRedeployIssueOnWls2 + EclipseLinkCoreMessages.warnEclipseRedeployIssueOnWls3;
        final boolean[] rets = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                rets[0] = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"EclipseLink JPA Provider Publisher", (String)message);
            }
        });
        return rets[0];
    }

    private boolean isUsingEclipseLinkUserLib(IProject project) {
        boolean ret = false;
        ILibraryProvider libProvider = LibraryProviderFrameworkImpl.get().getCurrentProvider(project, JptUtil.JPA_FACET);
        ILibraryProvider rootProvider = libProvider.getRootProvider();
        if ("user-library-provider".equals(rootProvider.getId())) {
            return true;
        }
        return ret;
    }

    private class PublishEclipseLinkJarToWlsDomainOperation
    extends WeblogicPublishOperation {
        public PublishEclipseLinkJarToWlsDomainOperation(IServer server) {
            super("PublishEclipseLink", "Publish EclipseLink JPA Provider To WebLogic Domain", server);
        }

        public int getOrder() {
            return 300;
        }

        protected void processRootModule(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
            if (mod.getKind() == 3) {
                return;
            }
            IModule module = mod.getModule();
            if (module instanceof DeletedModule) {
                return;
            }
            if (FacetUtil.hasWebFacet((IModule)module) || FacetUtil.hasEjbFacet((IModule)module)) {
                if (FacetUtil.hasProjectFacet((IModule)module, (IProjectFacet)JptUtil.JPA_FACET)) {
                    if (EclipseLinkJarPublishTask.this.isUsingEclipseLinkUserLib(module.getProject())) {
                        EclipseLinkJarPublishTask.this.copyEclipseLinkJarToDomain(module.getProject(), monitor);
                    }
                    return;
                }
                EclipseLinkJarPublishTask.this.checkReferencedProjects(module.getProject(), false, monitor);
            } else if (FacetUtil.hasEarFacet((IModule)module)) {
                EclipseLinkJarPublishTask.this.checkReferencedProjects(module.getProject(), true, monitor);
            }
        }
    }
}

