/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import oracle.eclipse.tools.database.connectivity.operations.IConstraintColumn;
import oracle.eclipse.tools.database.connectivity.operations.ICreateNewTableOperation;
import oracle.eclipse.tools.database.connectivity.operations.IPKConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IUniqueConstraint;
import oracle.eclipse.tools.database.connectivity.operations.internal.ConstraintColumnsValidator;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Status;

public final class UniqueConstraintColumnsValidator
extends ConstraintColumnsValidator {
    @Text(value="Unique key {0} columns match the primary key")
    private static LocalizableText containsSameColumnsAsPK;
    @Text(value="Unique key {0} columns match unique key {1}")
    private static LocalizableText containsSameColumnsAsUK;
    private Listener listener;

    static {
        LocalizableText.init(UniqueConstraintColumnsValidator.class);
    }

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                UniqueConstraintColumnsValidator.this.refresh();
            }
        };
        ICreateNewTableOperation op = (ICreateNewTableOperation)this.context(ICreateNewTableOperation.class);
        op.attach(this.listener, "PrimaryKey/ConstraintColumns/ColumnName");
        op.attach(this.listener, "UniqueConstraints/ConstraintColumns/ColumnName");
    }

    protected Status compute() {
        ElementList list = (ElementList)this.context(ElementList.of(IConstraintColumn.class));
        IUniqueConstraint uniqueConstraint = (IUniqueConstraint)list.nearest(IUniqueConstraint.class);
        if (uniqueConstraint.getName().validation().ok()) {
            ElementList<IConstraintColumn> pkCols;
            ICreateNewTableOperation operation = (ICreateNewTableOperation)list.nearest(ICreateNewTableOperation.class);
            IPKConstraint pk = (IPKConstraint)operation.getPrimaryKey().content();
            if (pk != null && this.containsSameColumns((ElementList<? extends IConstraintColumn>)list, pkCols = pk.getConstraintColumns())) {
                String msg = containsSameColumnsAsPK.format(new Object[]{uniqueConstraint.getName().content()});
                return Status.createErrorStatus((String)msg);
            }
            ElementList<IUniqueConstraint> uniqueConstraints = operation.getUniqueConstraints();
            for (IUniqueConstraint another : uniqueConstraints) {
                if (another == uniqueConstraint || !this.containsSameColumns((ElementList<? extends IConstraintColumn>)list, another.getConstraintColumns())) continue;
                String msg = containsSameColumnsAsUK.format(new Object[]{uniqueConstraint.getName().content(), another.getName().content()});
                return Status.createErrorStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        if (this.listener != null) {
            ICreateNewTableOperation op = (ICreateNewTableOperation)this.context(ICreateNewTableOperation.class);
            op.detach(this.listener, "PrimaryKey/ConstraintColumns/ColumnName");
            op.detach(this.listener, "UniqueConstraints/ConstraintColumns/ColumnName");
            this.listener = null;
        }
        super.dispose();
    }
}

