/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import oracle.eclipse.tools.database.connectivity.operations.IColumnDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class PrecisionValidator
extends ValidationService {
    protected void initValidationService() {
        ((IColumnDescriptor)this.context(IColumnDescriptor.class)).getType().attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PrecisionValidator.this.refresh();
            }
        });
    }

    protected Status compute() {
        Value obj = (Value)this.context(Value.of(Integer.class));
        Integer valueObj = (Integer)obj.content();
        if (valueObj != null) {
            int value = valueObj;
            IColumnDescriptor col = (IColumnDescriptor)obj.nearest(IColumnDescriptor.class);
            String type = (String)col.getType().content();
            if (type != null) {
                if (((type = type.toUpperCase()).startsWith("TIMESTAMP") || type.startsWith("INTERVAL")) && (value < 0 || value > 9)) {
                    return Status.createErrorStatus((String)Resources.timestampPrecisionMsg);
                }
                if (type.equals("NUMBER") && (value < 1 || value > 38)) {
                    String msg = NLS.bind((String)Resources.numberPrecisionMsg, (Object)"NUMBER");
                    return Status.createErrorStatus((String)msg);
                }
                if (type.equals("NUMERIC") && (value < 1 || value > 38)) {
                    String msg = NLS.bind((String)Resources.numberPrecisionMsg, (Object)"NUMERIC");
                    return Status.createErrorStatus((String)msg);
                }
                if (type.equals("DECIMAL") && (value < 1 || value > 38)) {
                    String msg = NLS.bind((String)Resources.numberPrecisionMsg, (Object)"DECIMAL");
                    return Status.createErrorStatus((String)msg);
                }
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String timestampPrecisionMsg;
        public static String numberPrecisionMsg;

        static {
            Resources.initializeMessages((String)PrecisionValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

