/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ObjectExistChecker {
    private static final String nameExistQuery = "select object_name from all_objects where owner = ? and object_name = ? and object_type = ?";
    private static PreparedStatement nameExistStmt;

    public static boolean objectExist(Connection connection, String owner, String name, String type) throws SQLException {
        boolean exist = false;
        ObjectExistChecker.initialize(connection);
        ResultSet rs = null;
        if (nameExistStmt != null) {
            try {
                nameExistStmt.setString(1, owner.toUpperCase());
                nameExistStmt.setString(2, name.toUpperCase());
                nameExistStmt.setString(3, type.toUpperCase());
                rs = nameExistStmt.executeQuery();
                if (rs.next()) {
                    exist = true;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        return exist;
    }

    private static void initialize(Connection connection) throws SQLException {
        if (nameExistStmt == null) {
            nameExistStmt = connection.prepareStatement(nameExistQuery);
        }
    }

    public static void close() throws SQLException {
        if (nameExistStmt != null) {
            nameExistStmt.close();
            nameExistStmt = null;
        }
    }
}

