/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.database.connectivity.operations.ICheckConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IColumnDescriptor;
import oracle.eclipse.tools.database.connectivity.operations.IConstraintColumn;
import oracle.eclipse.tools.database.connectivity.operations.ICreateNewTableOperation;
import oracle.eclipse.tools.database.connectivity.operations.IFKConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IFKConstraintColumnPair;
import oracle.eclipse.tools.database.connectivity.operations.IIndex;
import oracle.eclipse.tools.database.connectivity.operations.IPKConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IUniqueConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IndexType;
import oracle.eclipse.tools.database.connectivity.operations.OnDeleteType;
import org.eclipse.sapphire.ElementList;

public class NewTableDDLGenerator {
    public static final String CREATE_TABLE = "CREATE TABLE ";
    public static final String ALTER_TABLE = "ALTER TABLE ";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String LEFT_PAREN = "(";
    public static final String RIGHT_PAREN = ")";
    public static final String SPACE = " ";
    public static final String COMMA = ",";
    public static final String SEMI_COLON = ";";
    public static final String STAR = "*";
    public static final String DEFAULT = "DEFAULT";
    public static final String NOT_NULL = "NOT NULL";
    public static final String INDENT = "  ";
    public static final String CONSTRAINT = "CONSTRAINT";
    public static final String ADD_CONSTRAINT = "ADD CONSTRAINT ";
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    public static final String UNIQUE = "UNIQUE";
    public static final String FOREIGN_KEY = "FOREIGN KEY";
    public static final String REFERENCES = "REFERENCES ";
    public static final String CHECK = "CHECK ";
    public static final String CREATE = "CREATE ";
    public static final String INDEX = "INDEX ";
    public static final String ON = "ON ";
    public static final String ON_DELETE = "ON DELETE ";
    private static final String TIMESTAMP_TYPE = "TIMESTAMP";
    private static final String INTERVAL_DAY_TYPE = "INTERVAL DAY";
    private static final String TO_SECOND = "TO SECOND";
    private static final String INTERVAL_YEAR_TYPE = "INTERVAL YEAR";
    private static final String TO_MONTH = "TO MONTH";

    public static String generateNewTableDDL(ICreateNewTableOperation operation) {
        StringBuffer temp = new StringBuffer();
        temp.append(CREATE_TABLE);
        temp.append(NewTableDDLGenerator.generatedQualifiedName((String)operation.getSchema().content(), (String)operation.getName().content()));
        temp.append(NEWLINE);
        temp.append(LEFT_PAREN);
        temp.append(NEWLINE);
        ElementList<IColumnDescriptor> colDescriptors = operation.getColumns();
        int i = 0;
        while (i < colDescriptors.size()) {
            IColumnDescriptor colDescriptor = (IColumnDescriptor)colDescriptors.get(i);
            temp.append(INDENT);
            temp.append(NewTableDDLGenerator.generateColumn(colDescriptor));
            if (i < colDescriptors.size() - 1) {
                temp.append(COMMA);
            }
            temp.append(NEWLINE);
            ++i;
        }
        if (NewTableDDLGenerator.shouldGeneratePrimaryKey(operation)) {
            temp.append(COMMA);
            temp.append(NewTableDDLGenerator.generatePrimaryKey(operation));
        }
        temp.append(RIGHT_PAREN);
        temp.append(NEWLINE);
        temp.append(SEMI_COLON);
        temp.append(NEWLINE);
        temp.append(NEWLINE);
        if (NewTableDDLGenerator.shouldGenerateUniqueConstraints(operation)) {
            temp.append(NewTableDDLGenerator.generateUniqueConstraints(operation));
        }
        if (NewTableDDLGenerator.shouldGenerateForeignKeys(operation)) {
            temp.append(NewTableDDLGenerator.generateForeignKeys(operation));
        }
        if (NewTableDDLGenerator.shouldGenerateCheckConstraints(operation)) {
            temp.append(NewTableDDLGenerator.generateCheckConstraints(operation));
        }
        if (NewTableDDLGenerator.shouldGenerateIndexes(operation)) {
            temp.append(NewTableDDLGenerator.generateIndexes(operation));
        }
        return temp.toString();
    }

    private static void generateColumnPrecision(IColumnDescriptor colDescriptor, StringBuffer temp) {
        temp.append(LEFT_PAREN);
        temp.append(colDescriptor.getPrecision().text());
        if (colDescriptor.getScale().enabled() && !StringUtil.isEmpty((String)colDescriptor.getScale().text())) {
            temp.append(COMMA);
            temp.append(colDescriptor.getScale().text());
        }
        temp.append(RIGHT_PAREN);
        temp.append(SPACE);
    }

    private static void generateTimeOrIntervalType(IColumnDescriptor col, StringBuffer temp) {
        String type = ((String)col.getType().content()).toUpperCase();
        String precisionStr = col.getPrecision().text();
        if (type.startsWith(TIMESTAMP_TYPE)) {
            if (precisionStr != null) {
                String postfix = type.substring(9);
                temp.append(TIMESTAMP_TYPE);
                temp.append(LEFT_PAREN);
                temp.append(precisionStr);
                temp.append(RIGHT_PAREN);
                temp.append(postfix.toUpperCase());
            } else {
                temp.append(type);
            }
        } else if (type.equals(INTERVAL_DAY_TYPE)) {
            String dayPrecisionStr = col.getIntervalDayPrecision().text();
            String dayFractionalPrecisionStr = col.getIntervalDayFractionalPrecision().text();
            temp.append(INTERVAL_DAY_TYPE);
            if (dayPrecisionStr != null) {
                temp.append(LEFT_PAREN);
                temp.append(dayPrecisionStr);
                temp.append(RIGHT_PAREN);
            }
            temp.append(SPACE);
            temp.append(TO_SECOND);
            if (dayFractionalPrecisionStr != null) {
                temp.append(LEFT_PAREN);
                temp.append(dayFractionalPrecisionStr);
                temp.append(RIGHT_PAREN);
            }
        } else if (type.equals(INTERVAL_YEAR_TYPE)) {
            String yearPrecisionStr = col.getIntervalYearPrecision().text();
            temp.append(INTERVAL_YEAR_TYPE);
            if (yearPrecisionStr != null) {
                temp.append(LEFT_PAREN);
                temp.append(yearPrecisionStr);
                temp.append(RIGHT_PAREN);
            }
            temp.append(SPACE);
            temp.append(TO_MONTH);
        }
        temp.append(SPACE);
    }

    private static String generateColumn(IColumnDescriptor colDescriptor) {
        StringBuffer temp = new StringBuffer();
        temp.append((String)colDescriptor.getName().content());
        temp.append(SPACE);
        String colType = ((String)colDescriptor.getType().content()).toUpperCase();
        if (colType.startsWith(TIMESTAMP_TYPE) || colType.startsWith(INTERVAL_DAY_TYPE) || colType.startsWith(INTERVAL_YEAR_TYPE)) {
            NewTableDDLGenerator.generateTimeOrIntervalType(colDescriptor, temp);
        } else {
            temp.append((String)colDescriptor.getType().content());
            if (colDescriptor.getSize().enabled() && !StringUtil.isEmpty((String)colDescriptor.getSize().text())) {
                temp.append(LEFT_PAREN);
                temp.append(colDescriptor.getSize().text());
                temp.append(RIGHT_PAREN);
                temp.append(SPACE);
            } else if (colDescriptor.getPrecision().enabled() && !StringUtil.isEmpty((String)colDescriptor.getPrecision().text())) {
                NewTableDDLGenerator.generateColumnPrecision(colDescriptor, temp);
            } else if (colDescriptor.getScale().enabled() && !StringUtil.isEmpty((String)colDescriptor.getScale().text())) {
                temp.append(LEFT_PAREN);
                temp.append(STAR);
                temp.append(COMMA);
                temp.append(colDescriptor.getScale().text());
                temp.append(RIGHT_PAREN);
                temp.append(SPACE);
            } else {
                temp.append(SPACE);
            }
        }
        if (colDescriptor.getDefaultValue().enabled() && !StringUtil.isEmpty((String)colDescriptor.getDefaultValue().text())) {
            temp.append(DEFAULT);
            temp.append(SPACE);
            temp.append((String)colDescriptor.getDefaultValue().content());
        }
        if (colDescriptor.getNotnull().content() != null && ((Boolean)colDescriptor.getNotnull().content()).booleanValue()) {
            temp.append(SPACE);
            temp.append(NOT_NULL);
        }
        return temp.toString();
    }

    private static boolean shouldGeneratePrimaryKey(ICreateNewTableOperation operation) {
        return operation.getPrimaryKey().content(false) != null;
    }

    private static String generatePrimaryKey(ICreateNewTableOperation operation) {
        StringBuffer temp = new StringBuffer();
        temp.append(CONSTRAINT);
        temp.append(SPACE);
        temp.append((String)((IPKConstraint)operation.getPrimaryKey().content()).getName().content());
        temp.append(SPACE);
        temp.append(PRIMARY_KEY);
        temp.append(NEWLINE);
        temp.append(" (");
        temp.append(NEWLINE);
        ElementList<IConstraintColumn> constraintCols = ((IPKConstraint)operation.getPrimaryKey().content()).getConstraintColumns();
        boolean isFirst = true;
        int i = 0;
        while (i < constraintCols.size()) {
            IConstraintColumn constraintCol = (IConstraintColumn)constraintCols.get(i);
            if (!isFirst) {
                temp.append(COMMA);
                temp.append(NEWLINE);
            }
            temp.append(INDENT);
            temp.append((String)constraintCol.getColumnName().content());
            if (isFirst) {
                isFirst = false;
            }
            ++i;
        }
        temp.append(NEWLINE);
        temp.append(" )");
        temp.append(NEWLINE);
        return temp.toString();
    }

    private static boolean shouldGenerateUniqueConstraints(ICreateNewTableOperation operation) {
        return operation.getUniqueConstraints().size() > 0;
    }

    private static String generateUniqueConstraints(ICreateNewTableOperation operation) {
        StringBuffer temp = new StringBuffer();
        ElementList<IUniqueConstraint> uniqueConstraints = operation.getUniqueConstraints();
        for (IUniqueConstraint uniqueConstraint : uniqueConstraints) {
            String str = NewTableDDLGenerator.generateUniqueConstraint(operation, uniqueConstraint);
            temp.append(str);
        }
        return temp.toString();
    }

    private static String generateUniqueConstraint(ICreateNewTableOperation operation, IUniqueConstraint uniqueConstraint) {
        StringBuffer temp = new StringBuffer();
        temp.append(ALTER_TABLE);
        temp.append(NewTableDDLGenerator.generatedQualifiedName((String)operation.getSchema().content(), (String)operation.getName().content()));
        temp.append(SPACE);
        temp.append(NEWLINE);
        temp.append(ADD_CONSTRAINT);
        temp.append((String)uniqueConstraint.getName().content());
        temp.append(SPACE);
        temp.append(UNIQUE);
        temp.append(NEWLINE);
        temp.append(LEFT_PAREN);
        temp.append(NEWLINE);
        ElementList<IConstraintColumn> cols = uniqueConstraint.getConstraintColumns();
        int i = 0;
        while (i < cols.size()) {
            IConstraintColumn col = (IConstraintColumn)cols.get(i);
            temp.append(INDENT);
            temp.append((String)col.getColumnName().content());
            if (i < cols.size() - 1) {
                temp.append(COMMA);
            }
            temp.append(NEWLINE);
            ++i;
        }
        temp.append(RIGHT_PAREN);
        temp.append(NEWLINE);
        temp.append(SEMI_COLON);
        temp.append(NEWLINE);
        temp.append(NEWLINE);
        return temp.toString();
    }

    private static boolean shouldGenerateForeignKeys(ICreateNewTableOperation operation) {
        return operation.getForeignKeys().size() > 0;
    }

    private static String generateForeignKeys(ICreateNewTableOperation operation) {
        StringBuffer temp = new StringBuffer();
        ElementList<IFKConstraint> fks = operation.getForeignKeys();
        for (IFKConstraint fk : fks) {
            String str = NewTableDDLGenerator.generateForeignKey(operation, fk);
            temp.append(str);
        }
        return temp.toString();
    }

    private static String generateForeignKey(ICreateNewTableOperation operation, IFKConstraint fk) {
        IFKConstraintColumnPair colPair;
        StringBuffer temp = new StringBuffer();
        temp.append(ALTER_TABLE);
        temp.append(NewTableDDLGenerator.generatedQualifiedName((String)operation.getSchema().content(), (String)operation.getName().content()));
        temp.append(SPACE);
        temp.append(NEWLINE);
        temp.append(ADD_CONSTRAINT);
        temp.append((String)fk.getName().content());
        temp.append(SPACE);
        temp.append(FOREIGN_KEY);
        temp.append(NEWLINE);
        temp.append(LEFT_PAREN);
        temp.append(NEWLINE);
        ElementList<IFKConstraintColumnPair> associations = fk.getAssociations();
        int i = 0;
        while (i < associations.size()) {
            colPair = (IFKConstraintColumnPair)associations.get(i);
            temp.append(INDENT);
            temp.append((String)colPair.getLocalColumn().content());
            if (i < associations.size() - 1) {
                temp.append(COMMA);
            }
            temp.append(NEWLINE);
            ++i;
        }
        temp.append(RIGHT_PAREN);
        temp.append(NEWLINE);
        temp.append(REFERENCES);
        temp.append(NewTableDDLGenerator.generatedQualifiedName((String)fk.getReferencedSchema().content(), (String)fk.getReferencedTable().content()));
        temp.append(NEWLINE);
        temp.append(LEFT_PAREN);
        temp.append(NEWLINE);
        i = 0;
        while (i < associations.size()) {
            colPair = (IFKConstraintColumnPair)associations.get(i);
            temp.append(INDENT);
            temp.append((String)colPair.getReferencedColumn().content());
            if (i < associations.size() - 1) {
                temp.append(COMMA);
            }
            temp.append(NEWLINE);
            ++i;
        }
        temp.append(RIGHT_PAREN);
        temp.append(NEWLINE);
        if (fk.getOnDeleteType().content() != OnDeleteType.RESTRICT) {
            temp.append(ON_DELETE);
            temp.append(fk.getOnDeleteType());
        }
        temp.append(SEMI_COLON);
        temp.append(NEWLINE);
        temp.append(NEWLINE);
        return temp.toString();
    }

    private static boolean shouldGenerateCheckConstraints(ICreateNewTableOperation operation) {
        return operation.getCheckConstraints().size() > 0;
    }

    private static String generateCheckConstraints(ICreateNewTableOperation operation) {
        StringBuffer temp = new StringBuffer();
        ElementList<ICheckConstraint> checks = operation.getCheckConstraints();
        for (ICheckConstraint check : checks) {
            String str = NewTableDDLGenerator.generateCheckConstraint(operation, check);
            temp.append(str);
        }
        return temp.toString();
    }

    private static String generateCheckConstraint(ICreateNewTableOperation operation, ICheckConstraint check) {
        StringBuffer temp = new StringBuffer();
        temp.append(ALTER_TABLE);
        temp.append(NewTableDDLGenerator.generatedQualifiedName((String)operation.getSchema().content(), (String)operation.getName().content()));
        temp.append(SPACE);
        temp.append(NEWLINE);
        temp.append(ADD_CONSTRAINT);
        temp.append((String)check.getName().content());
        temp.append(SPACE);
        temp.append(CHECK);
        temp.append(NEWLINE);
        temp.append(LEFT_PAREN);
        temp.append((String)check.getCondition().content());
        temp.append(RIGHT_PAREN);
        temp.append(NEWLINE);
        temp.append(SEMI_COLON);
        temp.append(NEWLINE);
        temp.append(NEWLINE);
        return temp.toString();
    }

    private static boolean shouldGenerateIndexes(ICreateNewTableOperation operation) {
        return operation.getIndices().size() > 0;
    }

    private static String generateIndexes(ICreateNewTableOperation operation) {
        StringBuffer temp = new StringBuffer();
        ElementList<IIndex> indexes = operation.getIndices();
        for (IIndex index : indexes) {
            String str = NewTableDDLGenerator.generateIndex(operation, index);
            temp.append(str);
        }
        return temp.toString();
    }

    private static String generateIndex(ICreateNewTableOperation operation, IIndex index) {
        StringBuffer temp = new StringBuffer();
        temp.append(CREATE);
        IndexType indexType = (IndexType)((Object)index.getType().content());
        if (indexType != IndexType.NONUNIQUE) {
            temp.append(indexType.toString());
            temp.append(SPACE);
        }
        temp.append(INDEX);
        temp.append((String)index.getName().content());
        temp.append(SPACE);
        temp.append(ON);
        temp.append(NewTableDDLGenerator.generatedQualifiedName((String)operation.getSchema().content(), (String)operation.getName().content()));
        temp.append(LEFT_PAREN);
        ElementList<IConstraintColumn> cols = index.getIndexColumns();
        int i = 0;
        while (i < cols.size()) {
            IConstraintColumn col = (IConstraintColumn)cols.get(i);
            temp.append((String)col.getColumnName().content());
            if (i < cols.size() - 1) {
                temp.append(COMMA);
            }
            ++i;
        }
        temp.append(RIGHT_PAREN);
        temp.append(SEMI_COLON);
        temp.append(NEWLINE);
        temp.append(NEWLINE);
        return temp.toString();
    }

    private static String generatedQualifiedName(String schema, String table) {
        return String.valueOf(schema) + '.' + table;
    }
}

