/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import oracle.eclipse.tools.database.connectivity.operations.IConstraintColumn;
import oracle.eclipse.tools.database.connectivity.operations.ICreateNewTableOperation;
import oracle.eclipse.tools.database.connectivity.operations.internal.ConstraintColumnsValidator;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionException;

public final class ConstraintColumnValidator
extends ConstraintColumnsValidator {
    @Text(value="Column {0} of type {1} is invalid in a primary key constraint")
    private static LocalizableText invalidColumn;
    private Listener listener;

    static {
        LocalizableText.init(FunctionException.class);
    }

    protected void initValidationService() {
        super.initValidationService();
        ICreateNewTableOperation operation = (ICreateNewTableOperation)this.context(ICreateNewTableOperation.class);
        if (operation != null) {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    ConstraintColumnValidator.this.refresh();
                }
            };
            operation.attach(this.listener, "Columns/Name");
            operation.attach(this.listener, "Columns/Type");
        }
    }

    protected Status compute() {
        String colType;
        IConstraintColumn column = (IConstraintColumn)this.context(IConstraintColumn.class);
        ICreateNewTableOperation operation = (ICreateNewTableOperation)column.nearest(ICreateNewTableOperation.class);
        String colName = (String)column.getColumnName().content();
        if (colName != null && (colType = this.getColType(colName, operation)) != null && !this.canBeKey(colName, colType, operation)) {
            return Status.createErrorStatus((String)invalidColumn.format(new Object[]{colName, colType}));
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        if (this.listener != null) {
            ICreateNewTableOperation operation = (ICreateNewTableOperation)this.context(ICreateNewTableOperation.class);
            operation.detach(this.listener, "Columns/Name");
            operation.detach(this.listener, "Columns/Type");
            this.listener = null;
        }
        super.dispose();
    }
}

