/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.database.connectivity.operations.ICreateNewTableOperation;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.services.PossibleValuesService;

public class ColumnTypeValuesProvider
extends PossibleValuesService {
    public static final String INTERVAL_TYPE = "INTERVAL";
    public static final String INTERVAL_YEAR_TYPE = "INTERVAL YEAR";
    public static final String INTERVAL_DAY_TYPE = "INTERVAL DAY";

    protected void fillPossibleValues(Set<String> values) {
        Element model = ((Element)this.context(Element.class)).root();
        if (model instanceof ICreateNewTableOperation) {
            Schema schema;
            ICreateNewTableOperation newTableOp = (ICreateNewTableOperation)model;
            DatabaseDefinition dbDefinition = newTableOp.resolveDatabaseDefinition();
            if (dbDefinition != null) {
                Iterator iter = dbDefinition.getPredefinedDataTypes();
                while (iter.hasNext()) {
                    PredefinedDataTypeDefinition dataTypeDefinition = (PredefinedDataTypeDefinition)iter.next();
                    PredefinedDataType dataType = dbDefinition.getPredefinedDataType(dataTypeDefinition);
                    String typeName = dataType.getName();
                    if (typeName.equals(INTERVAL_TYPE)) {
                        values.add(INTERVAL_DAY_TYPE);
                        values.add(INTERVAL_YEAR_TYPE);
                        continue;
                    }
                    values.add(dataType.getName());
                }
            }
            if ((schema = newTableOp.resolveSchemaObject((String)newTableOp.getSchema().content())) != null) {
                EList udtList = schema.getUserDefinedTypes();
                for (Object typeObj : udtList) {
                    UserDefinedType udt = (UserDefinedType)typeObj;
                    values.add(udt.getName());
                }
            }
        }
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

