/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import oracle.eclipse.tools.database.connectivity.operations.IColumnDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class ColumnSizeValidator
extends ValidationService {
    protected void initValidationService() {
        ((IColumnDescriptor)this.context(IColumnDescriptor.class)).getType().attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ColumnSizeValidator.this.refresh();
            }
        });
    }

    protected Status compute() {
        Value obj = (Value)this.context(Value.of(Integer.class));
        IColumnDescriptor colDesc = (IColumnDescriptor)obj.element();
        String colType = (String)colDesc.getType().content();
        if (colType != null) {
            String colTypeUpper = colType.toUpperCase();
            if ((colTypeUpper.equals("NVARCHAR2") || colTypeUpper.equals("VARCHAR2") || colTypeUpper.equals("RAW")) && obj.content() == null) {
                String msg = NLS.bind((String)Resources.mustHaveSize, (Object)colType);
                return Status.createErrorStatus((String)msg);
            }
            if (obj.content() != null) {
                int size = (Integer)obj.content();
                if (colTypeUpper.equals("CHAR") && size > 2000) {
                    String msg = NLS.bind((String)Resources.sizeMsg, (Object)"CHAR", (Object)"2000");
                    return Status.createErrorStatus((String)msg);
                }
                if (colTypeUpper.equals("NCHAR") && size > 2000) {
                    String msg = NLS.bind((String)Resources.sizeMsg, (Object)"NCHAR", (Object)"2000");
                    return Status.createErrorStatus((String)msg);
                }
                if (colTypeUpper.equals("NVARCHAR2") && size > 4000) {
                    String msg = NLS.bind((String)Resources.sizeMsg, (Object)"NVARCHAR2", (Object)"4000");
                    return Status.createErrorStatus((String)msg);
                }
                if (colTypeUpper.equals("VARCHAR2") && size > 4000) {
                    String msg = NLS.bind((String)Resources.sizeMsg, (Object)"VARCHAR2", (Object)"4000");
                    return Status.createErrorStatus((String)msg);
                }
                if (colTypeUpper.equals("RAW") && size > 2000) {
                    String msg = NLS.bind((String)Resources.sizeMsg, (Object)"RAW", (Object)"2000");
                    return Status.createErrorStatus((String)msg);
                }
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String mustHaveSize;
        public static String sizeMsg;

        static {
            Resources.initializeMessages((String)ColumnSizeValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

