/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.db;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.DBToolsMessages;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleMaterializedView;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSequence;
import oracle.eclipse.tools.database.connectivity.editors.SourceInput;
import oracle.eclipse.tools.database.modelbase.db.OraPublicSynonym;
import oracle.eclipse.tools.database.modelbase.db.Synonym;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;

public class SourceUtil {
    public static final String CREATEORREPLACE = "CREATE OR REPLACE ";
    public static final String CREATE = "CREATE ";
    public static final String srcQuery = "select text,name from all_source s where s.name = ? and s.type = ? and s.owner  = ? order by line";
    public static final String errQuery = "select text,line,attribute,position from all_errors e, all_objects o where  o.object_name = e.name and o.object_type = e.type and o.owner = user and o.object_id = ?";
    public static final String sequenceQuery = "select sequence_name, min_value, max_value, increment_by, cache_size, last_number, cycle_flag, order_flag from all_sequences s where s.sequence_owner = ? and s.sequence_name = ?";
    public static final String synonymQuery = "select synonym_name, table_owner, table_name, db_link from all_synonyms s where s.owner = ? and s.synonym_name = ?";
    public static final String publicSynonymQuery = "select synonym_name, table_owner, table_name, db_link from all_synonyms s where s.owner = 'PUBLIC' and s.synonym_name = ?";
    public static final String mviewQuery = "select owner, mview_name, query, updatable, rewrite_enabled, refresh_mode, refresh_method, build_mode, use_no_index from all_mviews m where m.owner = ? and m.mview_name = ?";
    protected static final String NEWLINE = System.getProperty("line.separator");
    private Connection connection;

    public String getSource(SourceInput si, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getSource(si, quoteIdentifiers, qualifyNames, false);
    }

    public String getSource(SourceInput si, boolean quoteIdentifiers, boolean qualifyNames, boolean noTouch) {
        StringBuffer sb;
        block28: {
            if (si.getType().equals("SEQUENCE")) {
                return this.getSequenceSource((OracleSequence)si.getDatabaseObject().getOracleObject(), quoteIdentifiers, qualifyNames, noTouch);
            }
            if (si.getType().equals("SYNONYM")) {
                return this.getSynonymSource(si.getDatabaseObject().getOracleObject(), quoteIdentifiers, qualifyNames, noTouch);
            }
            if (si.getType().equals("MATERIALIZED VIEW")) {
                return this.getMaterializedViewSource((OracleMaterializedView)si.getDatabaseObject().getOracleObject(), quoteIdentifiers, qualifyNames, noTouch);
            }
            sb = new StringBuffer();
            if (!noTouch) {
                sb.append(CREATEORREPLACE);
            }
            CallableStatement stmt = null;
            ResultSet rset = null;
            try {
                try {
                    stmt = this.connection.prepareCall(srcQuery);
                    stmt.setString(1, si.getName());
                    stmt.setString(2, si.getType().toUpperCase());
                    stmt.setString(3, si.getOwner());
                    rset = stmt.executeQuery();
                    while (rset.next()) {
                        String text;
                        if (rset.isFirst()) {
                            si.setName(rset.getString(2));
                            si.setTooltip(rset.getString(2));
                        }
                        if (!(text = rset.getString(1)).endsWith(NEWLINE) && text.endsWith("\n")) {
                            sb.append(text.substring(0, text.length() - 1));
                            sb.append(NEWLINE);
                            continue;
                        }
                        sb.append(text);
                    }
                }
                catch (Exception e) {
                    sb.append(String.valueOf(NEWLINE) + e.getMessage());
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block28;
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rset != null) {
                        rset.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        String temp = sb.toString();
        if (noTouch) {
            return temp;
        }
        if (temp.equals(CREATEORREPLACE)) {
            String noSrcMsg = String.format(DBToolsMessages.unableToGetSource, si.getType().toUpperCase(), si.getName());
            return noSrcMsg;
        }
        temp = this.removeTerminator(temp);
        int nameBeginIndex = si.getType().toUpperCase().length() + CREATEORREPLACE.length();
        while (temp.charAt(nameBeginIndex) == ' ') {
            ++nameBeginIndex;
        }
        int nameEndIndex = nameBeginIndex + si.getName().length();
        if (temp.substring(nameBeginIndex, nameEndIndex).equalsIgnoreCase(si.getName())) {
            String modName = SourceUtil.getName(si.getOwner(), si.getName(), quoteIdentifiers, qualifyNames);
            temp = String.valueOf(temp.substring(0, nameBeginIndex)) + modName + temp.substring(nameEndIndex);
        }
        return temp;
    }

    private String removeTerminator(String str) {
        int len = str.length();
        int i = len - 1;
        while (i > 0) {
            char c = str.charAt(i);
            if (!Character.isWhitespace(c) && ';' != c) {
                return str.substring(0, i + 1);
            }
            --i;
        }
        return str;
    }

    public void annotateErrors(AnnotationModel model, SourceInput si, IDocument doc) {
        CallableStatement stmt = null;
        ResultSet rset = null;
        try {
            try {
                stmt = this.connection.prepareCall(errQuery);
                stmt.setBigDecimal(1, new BigDecimal(si.getId()));
                rset = stmt.executeQuery();
                model.removeAllAnnotations();
                while (rset.next()) {
                    int eLine = rset.getInt(2) - 1;
                    int ePos = rset.getInt(4);
                    int errPos = 0;
                    String[] lines = doc.get().split("\n");
                    if (eLine == lines.length) {
                        String[] stringArray = lines;
                        int n = lines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String element = stringArray[n2];
                            errPos = element.length() + 1 + errPos;
                            ++n2;
                        }
                        errPos -= 2;
                    } else {
                        int i = 0;
                        while (i < eLine) {
                            errPos = lines[i].length() + 1 + errPos;
                            ++i;
                        }
                        errPos += ePos;
                    }
                    if (rset.getString(3).equals("ERROR")) {
                        model.addAnnotation(new Annotation("org.eclipse.ui.workbench.texteditor.error", false, rset.getString(1)), new Position(errPos, 1));
                        continue;
                    }
                    if (!rset.getString(3).equals("WARNING")) continue;
                    model.addAnnotation(new Annotation("org.eclipse.ui.workbench.texteditor.warning", false, rset.getString(1)), new Position(errPos, 1));
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (rset != null) {
                        rset.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    private String getSequenceSource(OracleSequence s, boolean quoteIdentifiers, boolean qualifyNames, boolean noTouch) {
        StringBuffer sb;
        block25: {
            sb = new StringBuffer();
            if (!noTouch) {
                sb.append(CREATE);
            }
            sb.append("SEQUENCE ");
            CallableStatement stmt = null;
            ResultSet rset = null;
            try {
                try {
                    stmt = this.connection.prepareCall(sequenceQuery);
                    stmt.setString(1, s.getSchema().getName());
                    stmt.setString(2, s.getName());
                    rset = stmt.executeQuery();
                    if (rset.next()) {
                        String name = rset.getString(1);
                        String minValue = rset.getString(2);
                        String maxValue = rset.getString(3);
                        String incrementBy = rset.getString(4);
                        String cacheSize = rset.getString(5);
                        String lastNumber = rset.getString(6);
                        String cycleFlag = rset.getString(7);
                        String orderFlag = rset.getString(8);
                        sb.append(SourceUtil.getName(s.getSchema().getName(), name, quoteIdentifiers, qualifyNames));
                        sb.append(" MINVALUE ");
                        sb.append(minValue);
                        sb.append(" MAXVALUE ");
                        sb.append(maxValue);
                        sb.append(" INCREMENT BY ");
                        sb.append(incrementBy);
                        sb.append(" START WITH ");
                        sb.append(lastNumber);
                        if (cacheSize.equals("0")) {
                            sb.append(" NOCACHE");
                        } else {
                            sb.append(" CACHE ");
                            sb.append(cacheSize);
                        }
                        if (orderFlag.equalsIgnoreCase("Y")) {
                            sb.append(" ORDER");
                        } else {
                            sb.append(" NOORDER");
                        }
                        if (cycleFlag.equalsIgnoreCase("Y")) {
                            sb.append(" CYCLE");
                        } else {
                            sb.append(" NOCYCLE");
                        }
                    }
                }
                catch (Exception e) {
                    sb.append("\n" + e.getMessage());
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block25;
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rset != null) {
                        rset.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        return sb.toString();
    }

    private String getSynonymSource(OracleObject o, boolean quoteIdentifiers, boolean qualifyNames, boolean noTouch) {
        StringBuffer sb;
        block26: {
            assert (o instanceof Synonym);
            Synonym s = (Synonym)((Object)o);
            boolean isPublic = o instanceof OraPublicSynonym;
            sb = new StringBuffer();
            if (!noTouch) {
                sb.append(CREATEORREPLACE);
            }
            if (isPublic) {
                sb.append("PUBLIC ");
            }
            sb.append("SYNONYM ");
            PreparedStatement stmt = null;
            ResultSet rset = null;
            try {
                try {
                    if (isPublic) {
                        stmt = this.connection.prepareStatement(publicSynonymQuery);
                        stmt.setString(1, s.getName());
                    } else {
                        stmt = this.connection.prepareCall(synonymQuery);
                        stmt.setString(1, s.getSchema().getName());
                        stmt.setString(2, s.getName());
                    }
                    rset = stmt.executeQuery();
                    if (rset.next()) {
                        String name = rset.getString(1);
                        String tableOwner = rset.getString(2);
                        String tableName = rset.getString(3);
                        String dbLink = rset.getString(4);
                        if (isPublic) {
                            sb.append(SourceUtil.getName(null, name, quoteIdentifiers, qualifyNames));
                        } else {
                            sb.append(SourceUtil.getName(s.getSchema().getName(), name, quoteIdentifiers, qualifyNames));
                        }
                        sb.append(" FOR ");
                        sb.append(SourceUtil.getName(tableOwner, tableName, quoteIdentifiers, qualifyNames));
                        if (dbLink != null && dbLink.length() > 0) {
                            sb.append("@");
                            sb.append(SourceUtil.getName(null, dbLink, quoteIdentifiers, false));
                        }
                    }
                }
                catch (Exception e) {
                    sb.append("\n" + e.getMessage());
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block26;
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rset != null) {
                        rset.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        return sb.toString();
    }

    private String getMaterializedViewSource(OracleMaterializedView mv, boolean quoteIdentifiers, boolean qualifyNames, boolean noTouch) {
        StringBuffer sb;
        block27: {
            sb = new StringBuffer();
            if (!noTouch) {
                sb.append(CREATE);
            }
            sb.append("MATERIALIZED VIEW ");
            CallableStatement stmt = null;
            ResultSet rset = null;
            try {
                try {
                    stmt = this.connection.prepareCall(mviewQuery);
                    stmt.setString(1, mv.getSchema().getName());
                    stmt.setString(2, mv.getName());
                    rset = stmt.executeQuery();
                    if (rset.next()) {
                        String owner = rset.getString(1);
                        String mvName = rset.getString(2);
                        String query = rset.getString(3);
                        String updatable = rset.getString(4);
                        String rewriteEnabled = rset.getString(5);
                        String refreshMode = rset.getString(6);
                        String refreshMethod = rset.getString(7);
                        String buildMode = rset.getString(8);
                        String useNoIndex = rset.getString(9);
                        sb.append(SourceUtil.getName(owner, mvName, quoteIdentifiers, qualifyNames));
                        sb.append(NEWLINE);
                        if (buildMode.equals("IMMEDIATE") || buildMode.equals("DEFERRED")) {
                            sb.append("BUILD ");
                            sb.append(buildMode);
                            sb.append(NEWLINE);
                        }
                        if (useNoIndex.equals("N")) {
                            sb.append("USING INDEX");
                        } else {
                            sb.append("USING NO INDEX");
                        }
                        sb.append(NEWLINE);
                        if (refreshMode.equals("NEVER")) {
                            sb.append("NEVER REFRESH");
                            sb.append(NEWLINE);
                        } else {
                            sb.append("REFRESH ");
                            sb.append(refreshMethod);
                            sb.append(" ON ");
                            sb.append(refreshMode);
                            sb.append(NEWLINE);
                        }
                        if (updatable.equals("Y")) {
                            sb.append("FOR UPDATE ");
                        }
                        if (rewriteEnabled.equals("Y")) {
                            sb.append("ENABLE QUERY REWRITE");
                        } else {
                            sb.append("DISABLE QUERY REWRITE");
                        }
                        sb.append(NEWLINE);
                        sb.append("AS ");
                        sb.append(query);
                    }
                }
                catch (Exception e) {
                    sb.append("\n" + e.getMessage());
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block27;
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rset != null) {
                        rset.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String getName(String schemaName, String objectName, boolean quoteIdentifiers, boolean qualifyNames) {
        if (quoteIdentifiers) {
            objectName = "\"" + objectName + "\"";
            if (schemaName != null && schemaName.length() > 0) {
                schemaName = "\"" + schemaName + "\"";
            }
        }
        if (qualifyNames && schemaName != null && schemaName.length() > 0) {
            objectName = String.valueOf(schemaName) + "." + objectName;
        }
        return objectName;
    }
}

