/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.db;

import java.sql.Connection;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;

public class DatabaseObject {
    private String id;
    private String name;
    private String type;
    private String owner;
    private Connection connection;
    private OracleObject oracleObject;

    public DatabaseObject() {
    }

    public DatabaseObject(String debugClassName) {
        String[] tokens = debugClassName.split("\\.");
        if (tokens.length < 2 || !tokens[0].equals("$Oracle")) {
            this.type = tokens[1].toUpperCase();
        }
        if (this.isBuiltin()) {
            if (tokens.length != 3) {
                this.owner = null;
            }
            this.name = tokens[2];
        } else {
            if (tokens.length < 4) {
                OraclePlugin.getInstance().handleError(null, this, new RuntimeException("Unexpected oracle identifier!"));
            }
            this.owner = tokens[2];
            this.name = tokens[tokens.length - 1];
        }
    }

    public boolean isBuiltin() {
        return this.type.equals("BUILTIN");
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null && name.indexOf("(") > 0 ? name.substring(0, name.indexOf("(")) : name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOracleObject(OracleObject oracleObject) {
        this.oracleObject = oracleObject;
    }

    public OracleObject getOracleObject() {
        return this.oracleObject;
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        if (!(another instanceof DatabaseObject)) {
            return false;
        }
        DatabaseObject adb = (DatabaseObject)another;
        return adb.getType().equals(this.getType()) && adb.getOwner().equals(this.getOwner()) && adb.getId().equals(this.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getType() != null) {
            hashCode += this.getType().hashCode();
        }
        if (this.getOwner() != null) {
            hashCode += this.getOwner().hashCode();
        }
        if (this.getId() != null) {
            hashCode += this.getId().hashCode();
        }
        return hashCode;
    }
}

