/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.IOracleDropableObject;
import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObjectAction;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTableColumnLoader;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlParser;
import oracle.eclipse.tools.database.modelbase.db.impl.OraViewImpl;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleView
extends OraViewImpl
implements ICatalogObject,
OracleObject,
OracleObjectAction,
IPrivilegeObject,
IOracleDropableObject {
    private static final long serialVersionUID = 6154585331082419124L;
    private String id;
    private String status;
    public static final String TYPE = "VIEW";
    private boolean columnsLoaded = false;
    private boolean columnTypesLoaded = false;
    private boolean viewLoaded = false;
    private OracleTableColumnLoader columnLoader = new OracleTableColumnLoader(this);
    private String viewQuery = "SELECT TEXT FROM ALL_VIEWS WHERE VIEW_NAME = ?";

    @Override
    public String[] getSupportedPrivileges() {
        return PRIVILEGES1.toArray(new String[PRIVILEGES1.size()]);
    }

    @Override
    public String getOracleType() {
        return TYPE;
    }

    @Override
    public String getOwner() {
        return this.getSchema().getName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public synchronized void refresh() {
        this.columnsLoaded = false;
        this.columnTypesLoaded = false;
        this.viewLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    @Override
    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((OracleDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public synchronized EList getColumns() {
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public synchronized void loadColumnTypes() {
        if (this.columnTypesLoaded) {
            return;
        }
        this.columnLoader.loadColumnTypes();
        this.columnTypesLoaded = true;
    }

    public synchronized QueryExpression getQueryExpression() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.queryExpression;
    }

    public synchronized CheckType getCheckType() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.checkType;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getColumns();
        }
        if (id == 19) {
            this.getCheckType();
        }
        if (id == 18) {
            this.getQueryExpression();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            EList columns = super.getColumns();
            ArrayList existingCols = new ArrayList(columns);
            this.columnLoader.clearColumns((List)columns);
            this.columnLoader.loadColumns((List)columns, existingCols);
        }
        catch (SQLException e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.columnsLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadView() {
        boolean deliver;
        block19: {
            if (this.viewLoaded) {
                return;
            }
            Connection connection = this.getConnection();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            PreparedStatement s = null;
            ResultSet r = null;
            try {
                try {
                    s = connection.prepareStatement(this.viewQuery);
                    s.setString(1, this.getName());
                    r = s.executeQuery();
                    while (r.next()) {
                        String text = r.getString("TEXT");
                        OracleDdlParser ddlParser = new OracleDdlParser(this.getDatabaseDefinition());
                        ddlParser.parseView(this, text);
                    }
                    this.viewLoaded = true;
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    try {
                        if (r != null) {
                            r.close();
                        }
                        if (s != null) {
                            s.close();
                        }
                        break block19;
                    }
                    catch (Exception e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (r != null) {
                    r.close();
                }
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        this.eSetDeliver(deliver);
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this.getSchema().getDatabase();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
    }
}

