/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.modelbase.db.impl.OraTriggerImpl;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleTrigger
extends OraTriggerImpl
implements ICatalogObject,
OracleObject {
    private static final long serialVersionUID = 3976740254881363508L;
    private String id;
    private String status;
    private boolean columnLoaded = false;
    public static final String TYPE = "TRIGGER";
    private String columnQuery = "SELECT utc.COLUMN_NAME FROM USER_TRIGGER_COLS utc WHERE utc.TRIGGER_NAME = ? AND utc.TABLE_NAME = ?";

    @Override
    public String getOracleType() {
        return TYPE;
    }

    @Override
    public String getOwner() {
        return this.getSchema().getName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public void refresh() {
        if (this.columnLoaded) {
            this.triggerColumn.clear();
            this.columnLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public EList getTriggerColumn() {
        if (!this.columnLoaded) {
            this.loadColumn();
        }
        return this.triggerColumn;
    }

    public boolean isSystemObject() {
        return false;
    }

    @Override
    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 11) {
            this.getTriggerColumn();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumn() {
        boolean deliver;
        block20: {
            if (this.columnLoaded || !this.isUpdateType()) {
                return;
            }
            EList columnList = super.getTriggerColumn();
            Connection connection = this.getConnection();
            if (connection == null) {
                return;
            }
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            PreparedStatement s = null;
            ResultSet r = null;
            try {
                try {
                    s = connection.prepareStatement(this.columnQuery);
                    s.setString(1, this.getName());
                    s.setString(2, this.getSubjectTable().getName());
                    r = s.executeQuery();
                    while (r.next()) {
                        String colName = r.getString("COLUMN_NAME");
                        columnList.add((Object)this.getColumn(colName));
                    }
                    this.columnLoaded = true;
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    try {
                        if (r != null) {
                            r.close();
                        }
                        if (s != null) {
                            s.close();
                        }
                        break block20;
                    }
                    catch (Exception e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (r != null) {
                    r.close();
                }
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        this.eSetDeliver(deliver);
    }

    private Column getColumn(String columnName) {
        for (Column c : this.getSubjectTable().getColumns()) {
            if (!c.getName().equals(columnName)) continue;
            return c;
        }
        return null;
    }
}

