/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.catalog.OracleColumn;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.IntervalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntervalQualifierType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpressionDefault;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleTableColumnLoader
extends JDBCTableColumnLoader {
    public OracleTableColumnLoader(ICatalogObject catalogObject) {
        super(catalogObject);
    }

    protected ResultSet createResultSet() throws SQLException {
        Connection connection = this.getCatalogObject().getConnection();
        Table table = this.getTable();
        Schema schema = this.getTable().getSchema();
        DatabaseMetaData metaData = connection.getMetaData();
        String catalogName = null;
        if (metaData.supportsCatalogsInTableDefinitions()) {
            catalogName = connection.getCatalog();
        }
        ResultSet r = metaData.getColumns(catalogName, schema.getName(), table.getName(), null);
        return r;
    }

    protected void initialize(Column column, ResultSet rs) throws SQLException {
        column.setName(rs.getString("COLUMN_NAME"));
    }

    protected Column createColumn() {
        return new OracleColumn();
    }

    public void loadColumnTypes() {
        block32: {
            Table table = this.getTable();
            Schema schema = this.getTable().getSchema();
            Database database = schema.getDatabase();
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            ResultSet r = null;
            try {
                try {
                    r = this.createResultSet();
                    while (r.next()) {
                        String columnName = r.getString(4);
                        Column column = OracleTable.getColumn(table, columnName);
                        column.setName(columnName);
                        String remarks = r.getString(12);
                        column.setDescription(remarks);
                        String defaultValue = r.getString(13);
                        column.setDefaultValue(defaultValue);
                        String typeName = r.getString(6);
                        int timestampPrecesion = 6;
                        if (typeName.matches("TIMESTAMP\\([0-9]\\).*")) {
                            int len = typeName.indexOf(41) + 1;
                            timestampPrecesion = new Integer(typeName.substring(len - 2, len - 1));
                            typeName = typeName.endsWith("LOCAL TIME ZONE") ? "TIMESTAMP WITH LOCAL TIME ZONE" : (typeName.endsWith("TIME ZONE") ? "TIMESTAMP WITH TIME ZONE" : "TIMESTAMP");
                        } else if (typeName.startsWith("INTERVAL")) {
                            typeName = "INTERVAL";
                        }
                        PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                        if (typeDefinition != null) {
                            EStructuralFeature feature;
                            PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                            if (typeDefinition.isLengthSupported()) {
                                feature = type.eClass().getEStructuralFeature("length");
                                type.eSet(feature, (Object)r.getInt(7));
                            } else if (typeDefinition.isPrecisionSupported()) {
                                if (typeName.startsWith("TIMESTAMP")) {
                                    feature = type.eClass().getEStructuralFeature("fractionalSecondsPrecision");
                                    if (feature != null) {
                                        type.eSet(feature, (Object)timestampPrecesion);
                                    }
                                } else {
                                    feature = type.eClass().getEStructuralFeature("precision");
                                    type.eSet(feature, (Object)r.getInt(7));
                                }
                            }
                            if (typeDefinition.isScaleSupported()) {
                                feature = type.eClass().getEStructuralFeature("scale");
                                type.eSet(feature, (Object)r.getInt(9));
                            }
                            if (type instanceof IntervalDataType) {
                                IntervalDataType intervalType = (IntervalDataType)type;
                                String realName = r.getString(6);
                                if (realName.indexOf("DAY") != -1) {
                                    int dayPrecision = r.getInt(7);
                                    int fractionalPrecision = r.getInt(9);
                                    intervalType.setLeadingQualifier(IntervalQualifierType.DAY_LITERAL);
                                    intervalType.setLeadingFieldPrecision(dayPrecision);
                                    intervalType.setTrailingQualifier(IntervalQualifierType.SECOND_LITERAL);
                                    intervalType.setTrailingFieldPrecision(fractionalPrecision);
                                } else if (realName.indexOf("YEAR") != -1) {
                                    int yearPrecision = r.getInt(7);
                                    intervalType.setLeadingQualifier(IntervalQualifierType.YEAR_LITERAL);
                                    intervalType.setLeadingFieldPrecision(yearPrecision);
                                }
                            }
                            column.setContainedType((SQLDataType)type);
                        } else {
                            UserDefinedType udt = this.getUserDefinedType(schema, typeName);
                            if (udt != null) {
                                column.setReferencedType(udt);
                            } else {
                                ValueExpression expr = (ValueExpression)factory.create(SQLExpressionsPackage.eINSTANCE.getValueExpressionDefault());
                                column.setGenerateExpression(expr);
                                ((ValueExpressionDefault)expr).setSQL(typeName);
                            }
                        }
                        String nulls = r.getString(18);
                        if (nulls.equals("YES")) {
                            column.setNullable(true);
                            continue;
                        }
                        column.setNullable(false);
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    if (r == null) break block32;
                    try {
                        r.close();
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (SQLException e) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    }
                }
            }
        }
    }

    private UserDefinedType getUserDefinedType(Schema schema, String typeName) {
        UserDefinedType udt = null;
        EList udts = schema.getUserDefinedTypes();
        for (Object udtObj : udts) {
            if (!((UserDefinedType)udtObj).getName().equals(typeName)) continue;
            udt = (UserDefinedType)udtObj;
            break;
        }
        return udt;
    }
}

