/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.IOracleDropableObject;
import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObjectAction;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OracleIndex;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTableColumnLoader;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTrigger;
import oracle.eclipse.tools.database.connectivity.catalog.OracleUniqueConstraint;
import oracle.eclipse.tools.database.modelbase.db.impl.OraTableImpl;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCForeignKey;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCPrimaryKey;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsPackage;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleTable
extends OraTableImpl
implements ICatalogObject,
OracleObject,
OracleObjectAction,
IPrivilegeObject,
IOracleDropableObject {
    private String id;
    private String status;
    private static String tableIndexSql = "select i.owner, i.index_name, i.table_name, i.index_type, i.uniqueness, column_name from all_indexes i, all_ind_columns ic where i.index_name=ic.index_name and i.table_name=ic.table_name and i.owner=? and i.table_name=? order by i.index_name";
    private static PreparedStatement stmtGetTableIndex;
    private static String tableCCSql;
    private static String tableUCSql;
    private static String fkColsSql;
    private static String fkRefColsSql;
    private static String triggerQuery;
    private static final long serialVersionUID = 498951109735195053L;
    private boolean columnsLoaded = false;
    private boolean columnTypesLoaded = false;
    private boolean constraintsLoaded = false;
    private boolean constraintsLoading = false;
    private boolean indexesLoaded = false;
    private boolean triggersLoaded = false;
    public static final String TYPE = "TABLE";
    private OracleTableColumnLoader columnLoader = new OracleTableColumnLoader(this);

    static {
        tableCCSql = "select CONSTRAINT_NAME, SEARCH_CONDITION from ALL_CONSTRAINTS WHERE OWNER = ? AND TABLE_NAME = ? AND CONSTRAINT_TYPE = 'C'";
        tableUCSql = "select a.CONSTRAINT_NAME, c.column_name from all_CONSTRAINTS a, all_cons_columns c WHERE a.owner = c.owner and a.TABLE_NAME = c.table_name and constraint_type = 'U' and a.constraint_name = c.constraint_name and a.owner = ? and a.table_name= ? ";
        fkColsSql = "select a.CONSTRAINT_NAME, a.r_owner, a.r_constraint_name, a.delete_rule, c.column_name from all_constraints a, all_cons_columns c WHERE a.owner = c.owner and a.TABLE_NAME = c.table_name and constraint_type = 'R' and a.constraint_name = c.constraint_name and a.owner = ? and a.table_name = ? order by constraint_name, position";
        fkRefColsSql = "select table_name, column_name from all_cons_columns where owner = ? and constraint_name = ? order by position";
        triggerQuery = "SELECT t.TRIGGER_NAME, t.TRIGGERING_EVENT,t.TRIGGER_TYPE,t.TRIGGER_BODY, o.status, o.object_id FROM USER_TRIGGERS t, all_objects o WHERE t.TABLE_NAME = ? and o.owner = ? and o.object_type='TRIGGER' and t.trigger_name=o.object_name";
    }

    @Override
    public String[] getSupportedPrivileges() {
        ArrayList l = new ArrayList();
        l.addAll(new HashSet(PRIVILEGES2));
        l.addAll(new HashSet(PRIVILEGES1));
        return l.toArray(new String[l.size()]);
    }

    @Override
    public String getOracleType() {
        return TYPE;
    }

    @Override
    public String getOwner() {
        return this.getSchema().getName();
    }

    public synchronized void refresh() {
        this.columnsLoaded = false;
        this.columnTypesLoaded = false;
        if (this.constraintsLoaded) {
            this.constraintsLoaded = false;
            this.constraints.clear();
        }
        if (this.indexesLoaded) {
            this.indexesLoaded = false;
            this.index.clear();
        }
        if (this.triggersLoaded) {
            this.triggersLoaded = false;
            this.triggers.clear();
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public synchronized void refreshTrigger() {
        if (this.triggersLoaded) {
            this.triggersLoaded = false;
            this.triggers.clear();
        }
    }

    public boolean isSystemObject() {
        return false;
    }

    @Override
    public Connection getConnection() {
        Connection con = null;
        Database database = this.getCatalogDatabase();
        if (database != null) {
            con = ((OracleDatabase)database).getConnection();
        }
        return con;
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public synchronized EList getColumns() {
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public synchronized void loadColumnTypes() {
        if (this.columnTypesLoaded) {
            return;
        }
        this.columnLoader.loadColumnTypes();
        this.columnTypesLoaded = true;
    }

    public synchronized EList getConstraints() {
        if (!this.constraintsLoaded) {
            this.loadConstraints();
        }
        return this.constraints;
    }

    public synchronized EList getIndex() {
        if (!this.indexesLoaded) {
            this.loadIndexes();
        }
        return this.index;
    }

    public synchronized EList getTriggers() {
        if (!this.triggersLoaded) {
            this.loadTriggers();
        }
        return this.triggers;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getColumns();
        } else if (id == 18) {
            this.getConstraints();
        } else if (id == 14) {
            this.getIndex();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            EList columns = super.getColumns();
            ArrayList existingCols = new ArrayList(columns);
            this.columnLoader.clearColumns((List)columns);
            this.columnLoader.loadColumns((List)columns, existingCols);
        }
        catch (SQLException e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.columnsLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadIndexes() {
        if (this.indexesLoaded) {
            return;
        }
        this.indexesLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            OracleTable.loadIndexes(this.getConnection(), super.getIndex(), (Table)this);
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private synchronized void loadConstraints() {
        if (this.constraintsLoaded || this.constraintsLoading) {
            return;
        }
        this.constraintsLoading = true;
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            this.loadPrimaryKeys(metaData, super.getConstraints());
            this.loadForeignKeys(metaData, super.getConstraints());
            this.loadCheckKeys(super.getConstraints());
            this.loadUniqueConstraints(super.getConstraints());
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.constraintsLoading = false;
        this.constraintsLoaded = true;
        this.eSetDeliver(deliver);
    }

    public static void loadIndexes(Connection connection, EList indexList, Table table) throws SQLException {
        if (connection == null) {
            return;
        }
        try (ResultSet r = null;){
            Schema schema = table.getSchema();
            Database database = schema.getDatabase();
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            r = OracleTable.getTableIndexResultSet(connection, table);
            if (r == null) {
                return;
            }
            try {
                OracleIndex index = null;
                String previousIndex = null;
                while (r.next()) {
                    Column column;
                    String columnName;
                    String indexName = r.getString(2);
                    if (indexName == null) continue;
                    if (previousIndex == null || !indexName.equals(previousIndex)) {
                        index = new OracleIndex();
                        index.setName(indexName);
                        index.setSchema(table.getSchema());
                        String uniqueness = r.getString(5);
                        if (uniqueness.equals("UNIQUE")) {
                            index.setUnique(true);
                        } else {
                            index.setUnique(false);
                        }
                        indexList.add((Object)index);
                        previousIndex = indexName;
                    }
                    if ((columnName = r.getString(6)) == null || (column = OracleTable.getColumn(table, columnName)) == null) continue;
                    IndexMember member = (IndexMember)factory.create(SQLConstraintsPackage.eINSTANCE.getIndexMember());
                    member.setColumn(column);
                    index.getMembers().add((Object)member);
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }

    private synchronized void loadCheckKeys(EList constraintList) {
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        Database database = this.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = connection.prepareStatement(tableCCSql);
                stmt.setString(1, this.getSchema().getName().toUpperCase());
                stmt.setString(2, this.getName().toUpperCase());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    CheckConstraint cc = (CheckConstraint)factory.create(SQLConstraintsPackage.eINSTANCE.getCheckConstraint());
                    cc.setName(rs.getString("CONSTRAINT_NAME"));
                    SearchCondition sc = (SearchCondition)factory.create(SQLExpressionsPackage.eINSTANCE.getSearchConditionDefault());
                    sc.setSQL(rs.getString("SEARCH_CONDITION"));
                    cc.setSearchCondition(sc);
                    constraintList.add((Object)cc);
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }

    private synchronized void loadUniqueConstraints(EList constraintList) {
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        Database database = this.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = connection.prepareStatement(tableUCSql);
                stmt.setString(1, this.getSchema().getName().toUpperCase());
                stmt.setString(2, this.getName().toUpperCase());
                rs = stmt.executeQuery();
                HashMap<String, UniqueConstraint> ucMap = new HashMap<String, UniqueConstraint>();
                while (rs.next()) {
                    String colName;
                    Column column;
                    String ucName = rs.getString(1);
                    UniqueConstraint uc = (UniqueConstraint)ucMap.get(ucName);
                    if (uc == null) {
                        uc = (UniqueConstraint)factory.create(SQLConstraintsPackage.eINSTANCE.getUniqueConstraint());
                        uc.setName(ucName);
                        constraintList.add((Object)uc);
                    }
                    if ((column = OracleTable.getColumn((Table)this, colName = rs.getString(2))) != null) {
                        uc.getMembers().add((Object)column);
                    }
                    ucMap.put(ucName, uc);
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }

    private synchronized JDBCPrimaryKey loadPrimaryKeys(DatabaseMetaData metaData, EList constraintList) {
        JDBCPrimaryKey key = null;
        ResultSet r = null;
        try {
            try {
                r = metaData.getPrimaryKeys(null, this.getSchema().getName(), this.getName());
                RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
                KeyColumnCollection columns = new KeyColumnCollection((BaseTable)this);
                while (r.next()) {
                    if (key == null) {
                        String name = r.getString(6);
                        key = new JDBCPrimaryKey();
                        key.setName(name);
                        constraintList.add((Object)key);
                    }
                    String columnName = r.getString(4);
                    int seq = r.getInt(5);
                    columns.add(seq, columnName);
                }
                Iterator it = columns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    key.getMembers().add((Object)column);
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (SQLException se) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)se);
                }
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (SQLException se) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)se);
            }
        }
        return key;
    }

    private synchronized void loadForeignKeys(DatabaseMetaData metaData, EList constraintList) {
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        ResultSet r = null;
        Statement stmt = null;
        Statement referredStmt = null;
        try {
            try {
                String sName = this.getSchema().getName();
                String tName = this.getName();
                stmt = connection.prepareStatement(fkColsSql);
                stmt.setString(1, sName);
                stmt.setString(2, tName);
                r = stmt.executeQuery();
                HashMap<String, JDBCForeignKey> fkMap = new HashMap<String, JDBCForeignKey>();
                while (r.next()) {
                    String fkName = r.getString(1);
                    String onDelete = r.getString(4);
                    String fkColName = r.getString(5);
                    JDBCForeignKey fk = null;
                    if (fkMap.containsKey(fkName)) {
                        fk = (ForeignKey)fkMap.get(fkName);
                    } else {
                        fk = new JDBCForeignKey();
                        fk.setName(fkName);
                        if (onDelete.equals("CASCADE")) {
                            fk.setOnDelete(ReferentialActionType.CASCADE_LITERAL);
                        } else if (onDelete.equals("SET NULL")) {
                            fk.setOnDelete(ReferentialActionType.SET_NULL_LITERAL);
                        }
                        constraintList.add((Object)fk);
                        fkMap.put(fkName, fk);
                        String referredSchema = r.getString(2);
                        String referredConstraint = r.getString(3);
                        if (referredStmt == null) {
                            referredStmt = connection.prepareStatement(fkRefColsSql);
                        }
                        referredStmt.setString(1, referredSchema);
                        referredStmt.setString(2, referredConstraint);
                        ResultSet referredR = null;
                        try {
                            referredR = referredStmt.executeQuery();
                            String referredTableName = "";
                            OracleTable pkTable = null;
                            Object uc = null;
                            while (referredR.next()) {
                                String referredTableName2 = referredR.getString(1);
                                String referredColName = referredR.getString(2);
                                if (!referredTableName2.equals(referredTableName)) {
                                    pkTable = (OracleTable)this.getTable(referredSchema, referredTableName2);
                                    if (pkTable == null) continue;
                                    fk.setReferencedTable((BaseTable)pkTable);
                                    referredTableName = referredTableName2;
                                    uc = new OracleUniqueConstraint();
                                    uc.setName(fkName);
                                    uc.setBaseTable((BaseTable)pkTable);
                                    fk.setUniqueConstraint(uc);
                                } else {
                                    pkTable = (OracleTable)fk.getReferencedTable();
                                    uc = fk.getUniqueConstraint();
                                }
                                Column pkColumn = OracleTable.getColumn((Table)pkTable, referredColName);
                                if (pkColumn == null) continue;
                                fk.getReferencedMembers().add((Object)pkColumn);
                                uc.getMembers().add((Object)pkColumn);
                            }
                        }
                        finally {
                            try {
                                if (referredR != null) {
                                    referredR.close();
                                }
                            }
                            catch (SQLException se) {
                                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)se);
                            }
                        }
                    }
                    Column column = OracleTable.getColumn((Table)this, fkColName);
                    fk.getMembers().add((Object)column);
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (referredStmt != null) {
                        referredStmt.close();
                    }
                }
                catch (SQLException se) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)se);
                }
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (referredStmt != null) {
                    referredStmt.close();
                }
            }
            catch (SQLException se) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)se);
            }
        }
    }

    private synchronized void loadTriggers() {
        boolean deliver;
        block33: {
            if (this.triggersLoaded) {
                return;
            }
            EList triggerList = super.getTriggers();
            Object[] list = triggerList.toArray();
            this.clearTriggers(triggerList);
            Connection connection = this.getConnection();
            if (connection == null) {
                return;
            }
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Statement s = null;
            ResultSet r = null;
            try {
                try {
                    DataModelElementFactory factory = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
                    s = connection.prepareStatement(triggerQuery);
                    s.setString(1, this.name);
                    s.setString(2, this.getSchema().getName());
                    r = s.executeQuery();
                    while (r.next()) {
                        OracleTrigger trigger;
                        EClass metaclass;
                        String trigName = r.getString("TRIGGER_NAME");
                        Object element = OracleSchema.findElement(list, trigName, metaclass = SQLTablesPackage.eINSTANCE.getTrigger());
                        if (element != null) {
                            trigger = (OracleTrigger)element;
                            ((ICatalogObject)element).refresh();
                        } else {
                            trigger = new OracleTrigger();
                        }
                        trigger.setName(trigName);
                        trigger.setSchema(this.getSchema());
                        String trigEvent = r.getString("TRIGGERING_EVENT");
                        if (trigEvent.equals("INSERT")) {
                            trigger.setInsertType(true);
                        } else if (trigEvent.equals("DELETE")) {
                            trigger.setDeleteType(true);
                        } else if (trigEvent.equals("UPDATE")) {
                            trigger.setUpdateType(true);
                        }
                        String trigTime = r.getString("TRIGGER_TYPE");
                        if (trigTime.contains("STATEMENT")) {
                            trigger.setActionGranularity(ActionGranularityType.STATEMENT_LITERAL);
                        } else {
                            if (!trigTime.contains("ROW")) continue;
                            trigger.setActionGranularity(ActionGranularityType.ROW_LITERAL);
                        }
                        if (trigTime.contains("AFTER")) {
                            trigger.setActionTime(ActionTimeType.AFTER_LITERAL);
                        } else if (trigTime.contains("BEFORE")) {
                            trigger.setActionTime(ActionTimeType.BEFORE_LITERAL);
                        } else {
                            if (!trigTime.contains("INSTEAD")) continue;
                            trigger.setActionTime(ActionTimeType.INSTEADOF_LITERAL);
                        }
                        String text = r.getString("TRIGGER_BODY");
                        SQLStatement body = (SQLStatement)factory.create(SQLStatementsPackage.eINSTANCE.getSQLStatementDefault());
                        ((SQLStatementDefault)body).setSQL(text);
                        trigger.getActionStatement().add((Object)body);
                        String id = r.getString("object_id");
                        String status = r.getString("status");
                        trigger.setId(id);
                        trigger.setStatus(status);
                        triggerList.add((Object)trigger);
                    }
                    this.triggersLoaded = true;
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    try {
                        if (r != null) {
                            r.close();
                        }
                        if (s != null) {
                            s.close();
                        }
                        break block33;
                    }
                    catch (Exception e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (r != null) {
                    r.close();
                }
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void clearTriggers(EList triggerList) {
        for (OracleTrigger trigger : triggerList) {
            trigger.getActionStatement().clear();
            trigger.setSchema(null);
        }
        triggerList.clear();
    }

    private static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            SQLObject sqlObject = (SQLObject)element;
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == metaclass) {
                object = element;
                break;
            }
            ++n2;
        }
        return object;
    }

    private static Schema getSchema(Table table, String schemaName) {
        Schema s2 = table.getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database d = s2.getDatabase();
        OracleDatabase oracleDB = (OracleDatabase)d;
        for (Schema s2 : oracleDB.getAllSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        return null;
    }

    private Table getTable(String schemaName, String tableName) {
        Schema schema = OracleTable.getSchema((Table)this, schemaName);
        for (Table table : schema.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public static Column getColumn(Table table, String columnName) {
        for (Column c : table.getColumns()) {
            if (!c.getName().equals(columnName)) continue;
            return c;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public static ResultSet getTableIndexResultSet(Connection connection, Table table) throws SQLException {
        if (stmtGetTableIndex == null) {
            stmtGetTableIndex = connection.prepareStatement(tableIndexSql);
        }
        stmtGetTableIndex.setString(1, table.getSchema().getName());
        stmtGetTableIndex.setString(2, table.getName());
        ResultSet rs = stmtGetTableIndex.executeQuery();
        return rs;
    }

    private static class KeyColumnCollection {
        private final Map keyMap = new TreeMap();
        private BaseTable table;

        public KeyColumnCollection(BaseTable table) {
            this.table = table;
        }

        public void add(int seq, String name) {
            Column column = this.getColumn(name);
            String key = "k" + seq;
            this.keyMap.put(key, column);
        }

        public Iterator iterator() {
            return this.keyMap.values().iterator();
        }

        private Column getColumn(String name) {
            for (Column column : this.table.getColumns()) {
                if (!column.getName().equals(name)) continue;
                return column;
            }
            return null;
        }
    }
}

