/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleComposedType;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabaseLink;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDirectory;
import oracle.eclipse.tools.database.connectivity.catalog.OracleFunction;
import oracle.eclipse.tools.database.connectivity.catalog.OracleMaterializedView;
import oracle.eclipse.tools.database.connectivity.catalog.OracleOtherUser;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OracleProcedure;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePublicSynonym;
import oracle.eclipse.tools.database.connectivity.catalog.OracleRecycleBinObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSequence;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSynonym;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTable;
import oracle.eclipse.tools.database.connectivity.catalog.OracleView;
import oracle.eclipse.tools.database.modelbase.db.Synonym;
import oracle.eclipse.tools.database.modelbase.db.impl.OraSchemaImpl;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleSchema
extends OraSchemaImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3018607653689348199L;
    public static final String TYPE = "SCHEMA";
    private PreparedStatement stmtGetAll = null;
    private static final String sqlGetAllExceptRecycleBin = "select object_name,object_id,status from all_objects where owner = ? and object_type = ? and object_name not like 'BIN%' order by LAST_DDL_TIME desc";
    private static final String sqlGetAllFromRecycleBin = "select original_name, object_name, type from user_recyclebin";
    private static final String sqlGetDBLinks = "select * from all_db_links where owner = ?";
    private static final String systemUsers = "('SYS', 'SYSTEM', 'SYSMAN', 'DBSNMP', 'OUTLN', 'MDSYS', 'ORDSYS', 'ORDPLUGINS', 'CTXSYS', 'DSSYS', 'PERFSTAT', 'WKPROXY', 'WKSYS', 'WMSYS', 'XDB', 'ANONYMOUS', 'ODM', 'ODM_MTR', 'OLAPSYS', 'TRACESVR', 'REPADMIN', 'DMSYS', 'EXFSYS', 'lbacsys', 'mddata', 'mgmt_view', 'tracesrv', 'mtssys', 'oaspublic', 'websys', 'wk_proxy', 'wk_test')";
    private static final String sqlGetPublicSynonyms = "select s.synonym_name, o.object_id, o.status from all_synonyms s, all_objects o where s.owner = 'PUBLIC' and s.table_owner not in ('SYS', 'SYSTEM', 'SYSMAN', 'DBSNMP', 'OUTLN', 'MDSYS', 'ORDSYS', 'ORDPLUGINS', 'CTXSYS', 'DSSYS', 'PERFSTAT', 'WKPROXY', 'WKSYS', 'WMSYS', 'XDB', 'ANONYMOUS', 'ODM', 'ODM_MTR', 'OLAPSYS', 'TRACESVR', 'REPADMIN', 'DMSYS', 'EXFSYS', 'lbacsys', 'mddata', 'mgmt_view', 'tracesrv', 'mtssys', 'oaspublic', 'websys', 'wk_proxy', 'wk_test') and o.object_type = 'SYNONYM' and o.owner = 'PUBLIC' and s.synonym_name = o.object_name";
    private static final String sqlGetOthers = "select username from all_users WHERE username <> ? order by username";
    private boolean tablesLoaded = false;
    private boolean matViewsLoaded = false;
    private boolean routinesLoaded = false;
    private boolean sequencesLoaded = false;
    private boolean udtsLoaded = false;
    private boolean recycleBinLoaded = false;
    private boolean databaseLinksLoaded = false;
    private boolean packagesLoaded = false;
    private boolean synonymsLoaded = false;
    private boolean publicSynonymsLoaded = false;
    private boolean otherUsersLoaded = false;
    private boolean directoriesLoaded = false;

    public String getOracleType() {
        return TYPE;
    }

    private synchronized void loadTables() {
        if (this.tablesLoaded) {
            return;
        }
        EList list = super.getTables();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            OracleSchema.loadObjects(connection, (List)list, this, OracleTable.class);
            Vector aList = new Vector();
            OracleSchema.loadObjects(connection, aList, this, OracleView.class);
            list.addAll(aList);
            aList.clear();
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.tablesLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadMaterializedViews() {
        if (this.matViewsLoaded) {
            return;
        }
        EList list = super.getMaterializedViews();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            OracleSchema.loadObjects(connection, (List)list, this, OracleMaterializedView.class);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.matViewsLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadRoutines() {
        if (this.routinesLoaded) {
            return;
        }
        EList list = super.getRoutines();
        Vector functions = new Vector();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            OracleSchema.loadObjects(connection, (List)list, this, OracleProcedure.class);
            OracleSchema.loadObjects(connection, functions, this, OracleFunction.class);
            list.addAll(functions);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.routinesLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadSequences() {
        if (this.sequencesLoaded) {
            return;
        }
        EList list = super.getSequences();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            OracleSchema.loadObjects(connection, (List)list, this, OracleSequence.class);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.sequencesLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadUDTs() {
        if (this.udtsLoaded) {
            return;
        }
        EList list = super.getUserDefinedTypes();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            OracleSchema.loadObjects(connection, (List)list, this, OracleComposedType.class);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.udtsLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDatabaseLinks() {
        boolean deliver;
        block19: {
            if (this.databaseLinksLoaded) {
                return;
            }
            this.databaseLinks = super.getDatabaseLinks();
            this.databaseLinks.clear();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            PreparedStatement s = null;
            ResultSet r = null;
            try {
                try {
                    s = this.getConnection().prepareStatement(sqlGetDBLinks);
                    String owner = this.getName().toUpperCase();
                    s.setString(1, owner);
                    r = s.executeQuery();
                    while (r.next()) {
                        String linkName = r.getString(2);
                        String userName = r.getString(3);
                        String host = r.getString(4);
                        String created = r.getString(5);
                        OracleDatabaseLink dbLink = new OracleDatabaseLink();
                        dbLink.setName(linkName);
                        dbLink.setOwner(owner);
                        dbLink.setHost(host);
                        dbLink.setUserName(userName);
                        dbLink.setCreated(created);
                        dbLink.setId(linkName);
                        dbLink.setStatus("VALID");
                        this.databaseLinks.add((Object)dbLink);
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    try {
                        if (r != null) {
                            r.close();
                        }
                        if (s != null) {
                            s.close();
                        }
                        break block19;
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (s != null) {
                        s.close();
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (r != null) {
                    r.close();
                }
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        this.databaseLinksLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPackages() {
        if (this.packagesLoaded) {
            return;
        }
        this.packages = super.getPackages();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            OracleSchema.loadObjects(connection, (List)this.packages, this, OraclePackage.class);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.packagesLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadSynonyms() {
        if (this.synonymsLoaded) {
            return;
        }
        this.synonyms = super.getSynonyms();
        this.synonyms.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            OracleSchema.loadObjects(connection, (List)this.synonyms, this, OracleSynonym.class);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.synonymsLoaded = true;
        this.eSetDeliver(deliver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadObjects(Connection connection, List list, Schema schema, Class dbobject) throws SQLException {
        list.clear();
        try (ResultSet r = null;){
            try {
                OracleObject oo = (OracleObject)dbobject.newInstance();
                OracleSchema oSchema = (OracleSchema)schema;
                if (oSchema.stmtGetAll == null) {
                    oSchema.stmtGetAll = connection.prepareStatement(sqlGetAllExceptRecycleBin);
                }
                oSchema.stmtGetAll.setString(1, oSchema.getName().toUpperCase());
                oSchema.stmtGetAll.setString(2, oo.getOracleType());
                r = oSchema.stmtGetAll.executeQuery();
                while (r.next()) {
                    String name = r.getString("object_name");
                    String id = r.getString("object_id");
                    String status = r.getString("status");
                    oo = (OracleObject)dbobject.newInstance();
                    ENamedElement element = (ENamedElement)oo;
                    element.setName(name);
                    oo.setId(id);
                    oo.setStatus(status);
                    try {
                        list.add(oo);
                    }
                    catch (Exception e) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    }
                }
                return;
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                if (r == null) return;
                r.close();
                return;
            }
            catch (Error e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                if (r == null) return;
                r.close();
                return;
            }
        }
    }

    public synchronized void refresh() {
        this.tablesLoaded = false;
        this.matViewsLoaded = false;
        this.routinesLoaded = false;
        this.sequencesLoaded = false;
        this.udtsLoaded = false;
        this.recycleBinLoaded = false;
        this.databaseLinksLoaded = false;
        this.packagesLoaded = false;
        this.synonymsLoaded = false;
        this.publicSynonymsLoaded = false;
        this.otherUsersLoaded = false;
        this.directoriesLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public synchronized void refresh(String type) {
        if (type.equals("TABLE") || type.equals("VIEW")) {
            this.tablesLoaded = false;
        } else if (type.equals("MATERIALIZED VIEW")) {
            this.matViewsLoaded = false;
        } else if (type.equals("SEQUENCE")) {
            this.sequencesLoaded = false;
        } else if (type.equals("TYPE")) {
            this.udtsLoaded = false;
        } else if (type.equals("DATABASE LINK")) {
            this.databaseLinksLoaded = false;
        } else if (type.equals("PACKAGE") || type.equals("PACKAGE BODY")) {
            this.packagesLoaded = false;
        } else if (type.equals("DIRECTORY")) {
            this.directoriesLoaded = false;
        } else if (type.equals("RECYCLE BIN")) {
            this.recycleBinLoaded = false;
        } else if (type.equals("PROCEDURE") || type.equals("FUNCTION")) {
            this.routinesLoaded = false;
        }
    }

    public synchronized void refreshSynonyms(boolean isPublic) {
        if (isPublic) {
            this.publicSynonymsLoaded = false;
        } else {
            this.synonymsLoaded = false;
        }
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((OracleDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public synchronized EList getTables() {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tables;
    }

    @Override
    public synchronized EList getMaterializedViews() {
        if (!this.matViewsLoaded) {
            this.loadMaterializedViews();
            for (Object obj : this.materializedViews) {
                OracleMaterializedView matView = (OracleMaterializedView)obj;
                matView.setSchema(this);
            }
        }
        return this.materializedViews;
    }

    public synchronized EList getRoutines() {
        if (!this.routinesLoaded) {
            this.loadRoutines();
        }
        return this.routines;
    }

    public synchronized EList getSequences() {
        if (!this.sequencesLoaded) {
            this.loadSequences();
        }
        return this.sequences;
    }

    public synchronized EList getUserDefinedTypes() {
        if (!this.udtsLoaded) {
            this.loadUDTs();
        }
        return this.userDefinedTypes;
    }

    @Override
    public synchronized EList getRecycleBin() {
        if (!this.recycleBinLoaded) {
            this.loadRecycleBin();
        }
        return this.recycleBin;
    }

    @Override
    public synchronized EList getDatabaseLinks() {
        if (!this.databaseLinksLoaded) {
            this.loadDatabaseLinks();
        }
        return this.databaseLinks;
    }

    @Override
    public synchronized EList getPackages() {
        if (!this.packagesLoaded) {
            this.loadPackages();
        }
        return this.packages;
    }

    @Override
    public synchronized EList getSynonyms() {
        if (!this.synonymsLoaded) {
            this.loadSynonyms();
            for (Object obj : this.synonyms) {
                Synonym synonym = (Synonym)obj;
                synonym.setSchema(this);
            }
        }
        return this.synonyms;
    }

    @Override
    public synchronized EList getPublicSynonyms() {
        if (!this.publicSynonymsLoaded) {
            this.loadPublicSynonyms();
        }
        return this.publicSynonyms;
    }

    public synchronized boolean arePublicSynonymsLoaded() {
        return this.publicSynonymsLoaded;
    }

    @Override
    public synchronized EList getOtherUsers() {
        if (!this.otherUsersLoaded) {
            this.loadOtherUsers();
        }
        return this.otherUsers;
    }

    public synchronized void setDatabase(Database newDatabase) {
        this.database = newDatabase;
    }

    @Override
    public synchronized EList getDirectories() {
        if (!this.directoriesLoaded) {
            this.loadDirectories();
        }
        return this.directories;
    }

    private synchronized void loadRecycleBin() {
        if (this.recycleBinLoaded) {
            return;
        }
        EList list = super.getRecycleBin();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            OracleSchema.loadBin(connection, (List)list, this);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.recycleBinLoaded = true;
        this.eSetDeliver(deliver);
    }

    private static void loadBin(Connection connection, List list, Schema schema) throws SQLException {
        list.clear();
        PreparedStatement stmt = null;
        ResultSet r = null;
        try {
            try {
                stmt = connection.prepareStatement(sqlGetAllFromRecycleBin);
                r = stmt.executeQuery();
                while (r.next()) {
                    String name = r.getString("original_name");
                    String objectName = r.getString("object_name");
                    String type = r.getString("type");
                    OracleRecycleBinObject recycleBinObj = new OracleRecycleBinObject(name, objectName, type);
                    list.add(recycleBinObj);
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                if (r != null) {
                    r.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Error e) {
                block14: {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    if (r == null) break block14;
                    r.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected synchronized void loadOtherUsers() {
        if (this.otherUsersLoaded) {
            return;
        }
        EList list = super.getOtherUsers();
        list.clear();
        PreparedStatement stmtGetOthers = null;
        ResultSet r = null;
        try {
            try {
                stmtGetOthers = this.getConnection().prepareStatement(sqlGetOthers);
                stmtGetOthers.setString(1, this.getConnection().getMetaData().getUserName().toUpperCase());
                r = stmtGetOthers.executeQuery();
                while (r.next()) {
                    String schemaName = r.getString(1);
                    OracleOtherUser schema = new OracleOtherUser();
                    schema.setName(schemaName);
                    schema.setDatabase(this.getDatabase());
                    list.add((Object)schema);
                }
                this.otherUsersLoaded = true;
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (stmtGetOthers != null) {
                        stmtGetOthers.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (stmtGetOthers != null) {
                    stmtGetOthers.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }

    protected synchronized void loadDirectories() {
        if (this.directoriesLoaded) {
            return;
        }
        EList list = super.getDirectories();
        list.clear();
        Statement stmt = null;
        ResultSet r = null;
        try {
            try {
                String sql = "SELECT d.owner, d.directory_name, d.directory_path, o.object_id, o.status FROM all_directories d, all_objects o where o.object_type='DIRECTORY' and o.owner=d.owner and o.object_name=d.directory_name";
                stmt = this.getConnection().createStatement();
                r = stmt.executeQuery(sql);
                while (r.next()) {
                    String owner = r.getString(1);
                    String name = r.getString(2);
                    String path = r.getString(3);
                    String id = r.getString(4);
                    String status = r.getString(5);
                    OracleDirectory dir = new OracleDirectory();
                    dir.setOwner(owner);
                    dir.setName(name);
                    dir.setPath(path);
                    dir.setId(id);
                    dir.setStatus(status);
                    list.add((Object)dir);
                }
                this.directoriesLoaded = true;
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }

    protected synchronized void loadPublicSynonyms() {
        if (this.publicSynonymsLoaded) {
            return;
        }
        EList list = super.getPublicSynonyms();
        list.clear();
        Statement stmt = null;
        ResultSet r = null;
        try {
            try {
                stmt = this.getConnection().createStatement();
                r = stmt.executeQuery(sqlGetPublicSynonyms);
                while (r.next()) {
                    String name = r.getString("synonym_name");
                    String id = r.getString("object_id");
                    String status = r.getString("status");
                    OraclePublicSynonym synonym = new OraclePublicSynonym();
                    synonym.setName(name);
                    synonym.setSchema(this);
                    synonym.setId(id);
                    synonym.setStatus(status);
                    list.add((Object)synonym);
                }
                this.publicSynonymsLoaded = true;
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 10) {
            this.getTables();
        } else if (id == 17) {
            this.getRoutines();
        }
        return super.eIsSet(eFeature);
    }

    protected static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            SQLObject sqlObject = (SQLObject)element;
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == metaclass) {
                object = element;
                break;
            }
            ++n2;
        }
        return object;
    }
}

