/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObjectAction;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OracleParameter;
import oracle.eclipse.tools.database.modelbase.db.impl.OraProcedureImpl;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesFactory;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleProcedure
extends OraProcedureImpl
implements ICatalogObject,
OracleObject,
IPrivilegeObject,
OracleObjectAction {
    private static final long serialVersionUID = 4007235317417756337L;
    private String id;
    private String status;
    public static final String TYPE = "PROCEDURE";
    private PreparedStatement _stmt = null;
    private String oraclePackageName;
    private static String _sql = "SELECT text FROM all_source WHERE name = ? AND owner= ? AND type = 'PROCEDURE'";
    private boolean parameterLoaded = false;
    private boolean sourceLoaded = false;

    @Override
    public String[] getSupportedPrivileges() {
        return PRIVILEGES3.toArray(new String[PRIVILEGES3.size()]);
    }

    @Override
    public String getOracleType() {
        return TYPE;
    }

    @Override
    public String getOwner() {
        return this.getSchema().getName();
    }

    public String getOraclePackageName() {
        return this.oraclePackageName;
    }

    public void setOraclePackageName(String packageName) {
        this.oraclePackageName = packageName;
    }

    public synchronized void refresh() {
        this.parameterLoaded = false;
        this.sourceLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    @Override
    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((OracleDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public synchronized EList getParameters() {
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.parameters;
    }

    protected synchronized boolean isSourceLoaded() {
        return this.sourceLoaded;
    }

    protected synchronized void setSourceLoaded(boolean sourceLoaded) {
        this.sourceLoaded = sourceLoaded;
    }

    public synchronized Source getSource() {
        if (!this.sourceLoaded) {
            this.loadSource();
        }
        return this.source;
    }

    private synchronized void loadSource() {
        boolean deliver;
        block17: {
            if (this.sourceLoaded) {
                return;
            }
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Source src = SQLRoutinesFactory.eINSTANCE.createSource();
            ResultSet rs = null;
            try {
                try {
                    if (this._stmt == null) {
                        this._stmt = this.getConnection().prepareStatement(_sql);
                    }
                    this._stmt.setString(1, this.getName().toUpperCase());
                    this._stmt.setString(2, this.getSchema().getName().toUpperCase());
                    String body = "";
                    rs = this._stmt.executeQuery();
                    while (rs.next()) {
                        String text = rs.getString("text");
                        body = String.valueOf(body) + text;
                    }
                    src.setBody(body);
                    this.setSource(src);
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        break block17;
                    }
                    catch (Exception e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        this.sourceLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadParameters() {
        if (this.parameterLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            OracleProcedure.loadParameters(this.getConnection(), super.getParameters(), (Routine)this);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.parameterLoaded = true;
        this.eSetDeliver(deliver);
    }

    private static void loadParameters(Connection connection, EList parameterList, Routine routine) throws SQLException {
        Database database = routine.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet r = metaData.getProcedureColumns(null, routine.getSchema().getName(), routine.getName(), null);
        try {
            try {
                while (r.next()) {
                    OracleParameter parameter = new OracleParameter();
                    String name = r.getString(4);
                    parameter.setName(name);
                    short columntype = r.getShort(5);
                    if (columntype == 2) {
                        parameter.setMode(ParameterMode.INOUT_LITERAL);
                    } else if (columntype == 4) {
                        parameter.setMode(ParameterMode.OUT_LITERAL);
                    } else if (columntype == 1) {
                        parameter.setMode(ParameterMode.IN_LITERAL);
                    }
                    String typeName = r.getString(7);
                    PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                    if (typeDefinition != null) {
                        EStructuralFeature feature;
                        int length;
                        PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                        if (typeDefinition.isLengthSupported()) {
                            length = r.getInt(9);
                            feature = type.eClass().getEStructuralFeature("length");
                            type.eSet(feature, (Object)length);
                        } else if (typeDefinition.isPrecisionSupported()) {
                            length = r.getInt(8);
                            feature = type.eClass().getEStructuralFeature("precision");
                            type.eSet(feature, (Object)length);
                        }
                        if (typeDefinition.isScaleSupported()) {
                            length = r.getInt(10);
                            feature = type.eClass().getEStructuralFeature("scale");
                            type.eSet(feature, (Object)length);
                        }
                        parameter.setContainedType((SQLDataType)type);
                    }
                    parameterList.add((Object)parameter);
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }
}

