/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.IOracleDDLObject;
import oracle.eclipse.tools.database.connectivity.actions.IOracleDropableObject;
import oracle.eclipse.tools.database.connectivity.actions.IOracleEditableObject;
import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObjectAction;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageBody;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageFunc;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageObject;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageProc;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageSpecification;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.connectivity.db.SourceUtil;
import oracle.eclipse.tools.database.connectivity.editors.SourceInput;
import oracle.eclipse.tools.database.modelbase.db.PackageBody;
import oracle.eclipse.tools.database.modelbase.db.PackageSpecification;
import oracle.eclipse.tools.database.modelbase.db.impl.OraPackageImpl;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;

public class OraclePackage
extends OraPackageImpl
implements ICatalogObject,
OracleObject,
OracleObjectAction,
IOracleDropableObject,
IOracleDDLObject,
IOracleEditableObject,
IPrivilegeObject {
    private static final long serialVersionUID = 7017480868029132881L;
    private String id;
    private String status;
    private PreparedStatement stmt = null;
    private PreparedStatement functionStmt = null;
    private boolean specLoaded = false;
    private boolean bodyLoaded = false;
    private boolean hasBodyFlagSet = false;
    private boolean hasBody = false;
    private String bodyId = null;
    private String bodyStatus = null;
    private HashMap<String, Integer> specOverloadMap = new HashMap();
    private HashMap<String, Integer> bodyOverloadMap = new HashMap();
    public static final String TYPE = "PACKAGE";
    public static final String PACKAGE_BODY_TYPE = "PACKAGE BODY";
    public static final String PACKAGE_OBJECT_TYPE = "PACKAGE OBJECT";
    public static final String PACKAGE_BODY_OBJECT_TYPE = "PACKAGE BODY OBJECT";

    @Override
    public String getOracleType() {
        return TYPE;
    }

    @Override
    public String getOwner() {
        return this.getSchema().getName();
    }

    @Override
    public String[] getSupportedPrivileges() {
        return PRIVILEGES3.toArray(new String[PRIVILEGES3.size()]);
    }

    public synchronized void refresh() {
        this.specLoaded = false;
        this.bodyLoaded = false;
        this.hasBody = false;
        this.hasBodyFlagSet = false;
        this.specOverloadMap.clear();
        this.bodyOverloadMap.clear();
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    @Override
    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((OracleDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public synchronized PackageBody getBody() {
        if (!this.bodyLoaded) {
            this.loadBody();
        }
        return super.getBody();
    }

    public synchronized boolean hasPackageBody() {
        if (!this.hasBodyFlagSet) {
            block19: {
                Connection connection = this.getConnection();
                PreparedStatement bodyStatement = null;
                ResultSet bodyResultSet = null;
                this.hasBody = false;
                try {
                    try {
                        bodyStatement = connection.prepareStatement("SELECT object_name, object_id, status FROM ALL_OBJECTS WHERE object_name=? AND object_type=? AND owner=?");
                        bodyStatement.setString(1, this.getName());
                        bodyStatement.setString(2, PACKAGE_BODY_TYPE);
                        bodyStatement.setString(3, this.getSchema().getName());
                        bodyResultSet = bodyStatement.executeQuery();
                        if (bodyResultSet.next()) {
                            this.hasBody = true;
                            this.bodyId = bodyResultSet.getString(2);
                            this.bodyStatus = bodyResultSet.getString(3);
                        }
                    }
                    catch (Exception e) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                        try {
                            if (bodyStatement != null) {
                                bodyStatement.close();
                                bodyStatement = null;
                            }
                            if (bodyResultSet != null) {
                                bodyResultSet.close();
                                bodyResultSet = null;
                            }
                            break block19;
                        }
                        catch (Exception e2) {
                            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bodyStatement != null) {
                            bodyStatement.close();
                            bodyStatement = null;
                        }
                        if (bodyResultSet != null) {
                            bodyResultSet.close();
                            bodyResultSet = null;
                        }
                    }
                    catch (Exception e) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    if (bodyStatement != null) {
                        bodyStatement.close();
                        bodyStatement = null;
                    }
                    if (bodyResultSet != null) {
                        bodyResultSet.close();
                        bodyResultSet = null;
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
            }
            this.hasBodyFlagSet = true;
        }
        return this.hasBody;
    }

    private synchronized void loadBody() {
        PackageBody pb = super.getBody();
        if (pb == null) {
            pb = new OraclePackageBody(this);
            pb.setName(this.getName());
            ((OraclePackageBody)pb).setId(this.bodyId);
            ((OraclePackageBody)pb).setStatus(this.bodyStatus);
            super.setBody(pb);
        }
        EList decls = pb.getDeclarations();
        decls.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        if (this.hasPackageBody()) {
            String sql = this.getPackageBodySource((OraclePackageBody)pb);
            this.parsePackageBody(sql, decls);
        }
        this.bodyLoaded = true;
        this.eSetDeliver(deliver);
    }

    @Override
    public synchronized PackageSpecification getSpecification() {
        if (!this.specLoaded) {
            this.loadSpecification();
        }
        return super.getSpecification();
    }

    private synchronized void loadSpecification() {
        boolean deliver;
        block17: {
            PackageSpecification ps = super.getSpecification();
            if (ps == null) {
                ps = new OraclePackageSpecification(this);
                ps.setName(this.getName());
                super.setSpecification(ps);
            }
            EList decls = ps.getDeclarations();
            decls.clear();
            Connection connection = this.getConnection();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            ResultSet r = null;
            try {
                try {
                    if (this.stmt == null) {
                        this.stmt = connection.prepareStatement("SELECT procedure_name FROM USER_PROCEDURES WHERE object_name=?");
                    }
                    this.stmt.setString(1, this.getName());
                    r = this.stmt.executeQuery();
                    while (r.next()) {
                        String procedure_name = r.getString("procedure_name");
                        if (procedure_name == null || procedure_name.length() <= 0) continue;
                        boolean isFunction = this.isFunction(this.getName(), procedure_name);
                        OraclePackageObject packageObj = null;
                        packageObj = isFunction ? new OraclePackageFunc(procedure_name, PACKAGE_OBJECT_TYPE, this.getName()) : new OraclePackageProc(procedure_name, PACKAGE_OBJECT_TYPE, this.getName());
                        packageObj.setSchema(this.getSchema());
                        this.handleOverload(this.specOverloadMap, packageObj);
                        decls.add((Object)packageObj);
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    try {
                        if (r != null) {
                            r.close();
                        }
                        break block17;
                    }
                    catch (Exception e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        this.specLoaded = true;
        this.eSetDeliver(deliver);
    }

    private boolean isFunction(String packageName, String procName) throws SQLException {
        boolean ret = false;
        Connection connection = this.getConnection();
        ResultSet r = null;
        try {
            if (this.functionStmt == null) {
                this.functionStmt = connection.prepareStatement("SELECT argument_name FROM USER_ARGUMENTS WHERE object_name=? AND PACKAGE_NAME=? AND in_out='OUT'");
            }
            this.functionStmt.setString(1, procName);
            this.functionStmt.setString(2, packageName);
            r = this.functionStmt.executeQuery();
            if (r.next()) {
                ret = true;
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        return ret;
    }

    private String getPackageBodySource(OraclePackageBody packageBody) {
        DatabaseObject dbObject = new DatabaseObject();
        dbObject.setName(this.getName());
        dbObject.setType(packageBody.getOracleType());
        dbObject.setId(packageBody.getId());
        dbObject.setOwner(this.schema.getName());
        dbObject.setOracleObject(packageBody);
        SourceInput si = new SourceInput(dbObject);
        SourceUtil su = new SourceUtil();
        su.setConnection(((OracleSchema)this.schema).getConnection());
        String sql = su.getSource(si, false, false, true);
        return sql;
    }

    private void parsePackageBody(String sql, EList decls) {
        LinkedList src = LexerToken.parse((String)sql);
        LazyNode root = StackParser.parse((LinkedList)src);
        if (!root.startToken.equalsIgnoreCase("package")) {
            return;
        }
        List children = root.shallowChildren();
        if (children.size() == 1 && ((LazyNode)children.get(0)).isAs()) {
            List modules = ((LazyNode)children.get(0)).shallowChildren();
            for (LazyNode module : modules) {
                String procedureName;
                OraclePackageObject packageObj;
                LexerToken tok;
                if (module.startToken.equalsIgnoreCase("function")) {
                    String functionName;
                    if (module.from >= src.size() - 1 || (tok = (LexerToken)src.get(module.from + 1)) == null || (functionName = tok.content) == null || functionName.length() <= 0) continue;
                    packageObj = new OraclePackageFunc(functionName.toUpperCase(), PACKAGE_BODY_OBJECT_TYPE, this.getName());
                    this.handleOverload(this.bodyOverloadMap, packageObj);
                    packageObj.setSchema(this.getSchema());
                    decls.add((Object)packageObj);
                    continue;
                }
                if (!module.startToken.equalsIgnoreCase("procedure") || module.from >= src.size() - 1 || (tok = (LexerToken)src.get(module.from + 1)) == null || (procedureName = tok.content) == null || procedureName.length() <= 0) continue;
                packageObj = new OraclePackageProc(procedureName.toUpperCase(), PACKAGE_BODY_OBJECT_TYPE, this.getName());
                this.handleOverload(this.bodyOverloadMap, packageObj);
                packageObj.setSchema(this.getSchema());
                decls.add((Object)packageObj);
            }
        }
    }

    private void handleOverload(HashMap<String, Integer> overloadMap, OraclePackageObject packageObj) {
        Integer val = overloadMap.get(packageObj.getName());
        if (val == null) {
            overloadMap.put(packageObj.getName(), 1);
            packageObj.setOrder(1);
        } else {
            int newVal = val + 1;
            overloadMap.put(packageObj.getName(), newVal);
            packageObj.setOrder(newVal);
        }
    }
}

