/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.IOracleDropableObject;
import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObjectAction;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.modelbase.db.impl.MaterializedViewImpl;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCColumn;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpressionDefault;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleMaterializedView
extends MaterializedViewImpl
implements ICatalogObject,
OracleObject,
IPrivilegeObject,
IOracleDropableObject,
OracleObjectAction {
    private static final long serialVersionUID = 4491785933115003187L;
    private String id;
    private String status;
    public static final String TYPE = "MATERIALIZED VIEW";
    private boolean columnsLoaded = false;
    private boolean viewLoaded = false;

    @Override
    public String getOracleType() {
        return TYPE;
    }

    @Override
    public String getOwner() {
        return this.getSchema().getName();
    }

    @Override
    public String[] getSupportedPrivileges() {
        ArrayList<List> l = new ArrayList<List>();
        l.addAll(new HashSet<List>(Arrays.asList(PRIVILEGES2)));
        l.addAll(new HashSet<List>(Arrays.asList(PRIVILEGES1)));
        return l.toArray(new String[l.size()]);
    }

    public void setSchema(Schema newSchema) {
        this.schema = newSchema;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public synchronized void refresh() {
        this.columnsLoaded = false;
        this.viewLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    @Override
    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((OracleDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public synchronized EList getColumns() {
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public synchronized QueryExpression getQueryExpression() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.queryExpression;
    }

    public synchronized CheckType getCheckType() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.checkType;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getColumns();
        }
        if (id == 19) {
            this.getCheckType();
        }
        if (id == 18) {
            this.getQueryExpression();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        boolean deliver;
        block23: {
            if (this.columnsLoaded) {
                return;
            }
            EList columnList = super.getColumns();
            columnList.clear();
            Connection connection = this.getConnection();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            ResultSet r = null;
            try {
                try {
                    DatabaseMetaData metaData = this.getConnection().getMetaData();
                    String catalogName = null;
                    if (metaData.supportsCatalogsInTableDefinitions()) {
                        catalogName = connection.getCatalog();
                    }
                    DatabaseDefinition databaseDefinition = this.getDatabaseDefinition();
                    DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
                    r = metaData.getColumns(catalogName, this.getSchema().getName(), this.getName(), null);
                    while (r.next()) {
                        JDBCColumn column = new JDBCColumn();
                        String columnName = r.getString(4);
                        column.setName(columnName);
                        String remarks = r.getString(12);
                        column.setDescription(remarks);
                        String typeName = r.getString(6);
                        PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                        if (typeDefinition != null) {
                            EStructuralFeature feature;
                            PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                            if (typeDefinition.isLengthSupported()) {
                                feature = type.eClass().getEStructuralFeature("length");
                                type.eSet(feature, (Object)r.getInt(7));
                            } else if (typeDefinition.isPrecisionSupported()) {
                                feature = type.eClass().getEStructuralFeature("precision");
                                type.eSet(feature, (Object)r.getInt(10));
                            }
                            if (typeDefinition.isScaleSupported()) {
                                feature = type.eClass().getEStructuralFeature("scale");
                                type.eSet(feature, (Object)r.getInt(9));
                            }
                            column.setContainedType((SQLDataType)type);
                        } else {
                            ValueExpression expr = (ValueExpression)factory.create(SQLExpressionsPackage.eINSTANCE.getValueExpressionDefault());
                            column.setGenerateExpression(expr);
                            ((ValueExpressionDefault)expr).setSQL(typeName);
                        }
                        columnList.add((Object)column);
                    }
                    this.columnsLoaded = true;
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    try {
                        if (r != null) {
                            r.close();
                        }
                        break block23;
                    }
                    catch (Exception e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadView() {
        if (this.viewLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        this.eSetDeliver(deliver);
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this.getSchema().getDatabase();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
    }
}

