/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTable;
import oracle.eclipse.tools.database.connectivity.catalog.OracleView;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.impl.ColumnImpl;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleColumn
extends ColumnImpl
implements ICatalogObject {
    private boolean identityLoaded = false;
    private boolean columnTypeLoaded = false;
    private static final long serialVersionUID = -3609456397913750911L;

    public void refresh() {
        this.identityLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((OracleDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getTable().getSchema().getDatabase();
    }

    public IdentitySpecifier getIdentitySpecifier() {
        if (!this.identityLoaded) {
            this.loadIdentity();
        }
        return this.identitySpecifier;
    }

    public String getDefaultValue() {
        if (!this.identityLoaded) {
            this.loadIdentity();
        }
        return this.defaultValue;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 11) {
            this.getIdentitySpecifier();
        } else if (id == 15) {
            this.getDefaultValue();
        }
        return super.eIsSet(eFeature);
    }

    public void setDataType(DataType newType) {
        this.columnTypeLoaded = true;
        super.setDataType(newType);
    }

    public void setContainedType(SQLDataType value) {
        this.columnTypeLoaded = true;
        super.setContainedType(value);
    }

    public DataType getDataType() {
        if (!this.columnTypeLoaded) {
            this.loadColumnType();
        }
        return super.getDataType();
    }

    public String getDescription() {
        if (!this.columnTypeLoaded) {
            this.loadColumnType();
        }
        return super.getDescription();
    }

    public SQLDataType getContainedType() {
        if (!this.columnTypeLoaded) {
            this.loadColumnType();
        }
        return super.getContainedType();
    }

    public boolean isNullable() {
        if (!this.columnTypeLoaded) {
            this.loadColumnType();
        }
        return super.isNullable();
    }

    private synchronized void loadIdentity() {
        if (this.identityLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        OracleColumn.loadIdentity(connection, (Column)this);
        this.identityLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadColumnType() {
        Table table = this.getTable();
        if (table instanceof OracleView) {
            ((OracleView)table).loadColumnTypes();
        } else if (table instanceof OracleTable) {
            ((OracleTable)table).loadColumnTypes();
        }
        this.columnTypeLoaded = true;
    }

    public static void loadIdentity(Connection connection, Column column) {
    }
}

