/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database;

import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.eclipse.tools.database.connectivity.DBToolsMessages;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;

public final class OraclePlugin
extends Plugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.database";
    private static OraclePlugin plugin;
    private static final ResourceBundle resourceBundle;
    private static int id;

    static {
        resourceBundle = null;
        id = 0;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = OraclePlugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static IStatus createErrorStatus(String msg) {
        return OraclePlugin.createErrorStatus(msg, null);
    }

    public static IStatus createErrorStatus(Throwable e) {
        return OraclePlugin.createErrorStatus(null, e);
    }

    public static IStatus createErrorStatus(String msg, Throwable e) {
        String message = msg;
        if (msg == null && e != null) {
            message = e.getMessage();
        }
        return new Status(4, PLUGIN_ID, 0, message, e);
    }

    public static CoreException createCoreException(String msg) {
        return OraclePlugin.createCoreException(msg, null);
    }

    public static CoreException createCoreException(String msg, Throwable e) {
        return new CoreException(OraclePlugin.createErrorStatus(msg, e));
    }

    public static OraclePlugin getInstance() {
        return plugin;
    }

    public static synchronized String nextId() {
        return String.valueOf(id++);
    }

    public boolean handleError(Composite source, DatabaseObject dbo, Throwable t) {
        ILog log = this.getLog();
        log.log((IStatus)new Status(4, OraclePlugin.getInstance().toString(), 0, String.valueOf(dbo.getOwner()) + "." + dbo.getName() + ":" + t.getMessage(), t));
        try {
            CommitOptionDialog dlg = new CommitOptionDialog(source.getShell());
            dlg.updateStatus((IStatus)new Status(4, ((Object)((Object)this)).getClass().toString(), -1, DBToolsMessages.errorMsg, t));
            dlg.open();
            dbo.getConnection().rollback();
            return dlg.getReturnCode() == 0;
        }
        catch (SQLException se1) {
            se1.printStackTrace();
            return true;
        }
    }

    private static class CommitOptionDialog
    extends StatusDialog {
        Label label = null;

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginHeight = 15;
            gridLayout.marginWidth = 15;
            container.setLayout((Layout)gridLayout);
            this.label = new Label(container, 16388);
            this.label.setFont(container.getFont());
            this.label.setText(super.getStatus().getMessage());
            return container;
        }

        private CommitOptionDialog(Shell parent) {
            super(parent);
            super.setTitle(DBToolsMessages.saveChangeDlgTitle);
        }

        protected void updateButtonsEnableState(IStatus status) {
        }

        public void updateStatus(IStatus status) {
            super.updateStatus(status);
        }
    }
}

