/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jstl.tagsupport.converter.operations;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jstl.JSTLPlugin;
import oracle.eclipse.tools.webtier.jstl.tagsupport.converter.operations.AbstractJSTLCheckTableTransformOperation;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Element;

public class WhenOtherwiseOperation
extends AbstractJSTLCheckTableTransformOperation {
    private static final String DIV_STYLE_FOR_LABEL = "color:#999999; font-family:sans-serif; font-size:10pt; vertical-align:middle; white-space:nowrap; border-top: 1px solid red; border-bottom: 1px solid red; padding: 0; margin: 0";

    @Override
    protected Element renderDefault(Element srcElem, int tableElement) {
        if (this.getParameters().length < 1) {
            String message = "Too few parameters specified in metadata for operation " + this.getTransformOperationID();
            LoggingService.logError((String)JSTLPlugin.getPluginId(), (String)message);
            return null;
        }
        String imgSrcValue = this.getParameters()[0];
        Assert.isNotNull((Object)imgSrcValue);
        String attrName = null;
        if (this.getParameters().length > 1) {
            attrName = this.getParameters()[1];
            Assert.isNotNull((Object)attrName);
        }
        Element divEle = this.createElement("div");
        String style = "border:0; padding: 0; margin: 0";
        divEle.setAttribute("style", style);
        Element div2 = this.appendChildElement("div", divEle);
        div2.setAttribute("style", DIV_STYLE_FOR_LABEL);
        Element img = this.appendChildElement("img", div2);
        String srcValue = this.resolveFileLocation("$nl$/" + imgSrcValue);
        img.setAttribute("src", srcValue);
        img.setAttribute("style", "border:0; padding: 0; margin:0px 3px 0px 0px; vertical-align:middle;");
        if (attrName != null) {
            this.appendTagNameAsChildText(srcElem, div2, attrName, "false");
        } else {
            this.appendTagNameAsChildText(srcElem, div2, null, null);
        }
        this.createElementAndCopyChildren(srcElem, divEle, tableElement);
        return divEle;
    }
}

